#include <reg52.h>
#include <intrins.h>

typedef unsigned char uchar;
typedef unsigned char uint;
//****************************************IO|[g`***************************************
sbit 	MISO	=P1^2;
sbit 	MOSI	=P3^2;
sbit	SCK	    =P1^6;
sbit	CE	    =P1^5;
sbit	CSN		=P1^7;
sbit	IRQ		=P1^3;
//***********************************fW^0-9R[fBO*******************************************
uchar seg[10]={0xC0,0xCF,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,0x90};         //0~~9ZNVR[h
uchar TxBuf[32]=
{
0x01,0x02,0x03,0x4,0x05,0x06,0x07,0x08,
0x09,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
0x17,0x18,0x19,0x20,0x21,0x22,0x23,0x24,
0x25,0x26,0x27,0x28,0x29,0x30,0x31,0x32,
};	 // 
//************************************L[**********************************************
sbit	KEY1=P3^6;
sbit	KEY2=P3^7;
//***********************************fW^ǃrbgZNg**************************************************
sbit	led1=P2^1;
sbit	led0=P2^0;
sbit	led2=P2^2;
sbit	led3=P2^3;
//*********************************************NRF24L01*************************************
#define TX_ADR_WIDTH    5   	// 5 uints TX address width
#define RX_ADR_WIDTH    5   	// 5 uints RX address width
#define TX_PLOAD_WIDTH  32  	// 20 uints TX payload
#define RX_PLOAD_WIDTH  32  	// 20 uints TX payload
uint const TX_ADDRESS[TX_ADR_WIDTH]= {0x34,0x43,0x10,0x10,0x01};	//[JAhX
uint const RX_ADDRESS[RX_ADR_WIDTH]= {0x34,0x43,0x10,0x10,0x01};	//MAhX
//***************************************NRF24L01WX^R}h*******************************************************
#define READ_REG        0x00  	// WX^ǂݎR}h
#define WRITE_REG       0x20 	// WX^݃R}h
#define RD_RX_PLOAD     0x61  	// f[^MǂݎR}h
#define WR_TX_PLOAD     0xA0  	// \Mf[^݃R}h
#define FLUSH_TX        0xE1 	// MFIFOR}htbV
#define FLUSH_RX        0xE2  	// MFIFOR}htbV
#define REUSE_TX_PL     0xE3  	// f[^JԂ[hR}h`
#define NOP             0xFF  	// eV
//*************************************SPI(nRF24L01)WX^AhX****************************************************
#define CONFIG          0x00  // 󑗐MXe[^XݒACRC`FbN[hƎ󑗐MXe[^X
#define EN_AA           0x01  // @\ݒ
#define EN_RXADDR       0x02  // p`lݒ
#define SETUP_AW        0x03  // 󑗐MAhXݒ
#define SETUP_RETR      0x04  // đM@\ݒ
#define RF_CH           0x05  // gݒ
#define RF_SETUP        0x06  // MgAd͏ݒ
#define STATUS          0x07  // Xe[^XWX^
#define OBSERVE_TX      0x08  // Mϑ@\
#define CD              0x09  // AhX
#define RX_ADDR_P0      0x0A  // `l0f[^MAhX
#define RX_ADDR_P1      0x0B  // `l1f[^MAhX
#define RX_ADDR_P2      0x0C  // `l2f[^MAhX
#define RX_ADDR_P3      0x0D  // `l3f[^MAhX
#define RX_ADDR_P4      0x0E  // `l4f[^MAhX
#define RX_ADDR_P5      0x0F  // `l5f[^MAhX
#define TX_ADDR         0x10  // MAhXWX^
#define RX_PW_P0        0x11  // M`l0f[^Mx
#define RX_PW_P1        0x12  // M`l0f[^Mx
#define RX_PW_P2        0x13  // M`l0f[^Mx
#define RX_PW_P3        0x14  // M`l0f[^Mx
#define RX_PW_P4        0x15  // M`l0f[^Mx
#define RX_PW_P5        0x16  // M`l0f[^Mx
#define FIFO_STATUS     0x17  // FIFOX^bNc[X^bNXe[^XWX^ݒ
//**************************************************************************************
void Delay(unsigned int s);
void inerDelay_us(unsigned char n);
void init_NRF24L01(void);
uint SPI_RW(uint uchar);
uchar SPI_Read(uchar reg);
void SetRX_Mode(void);
uint SPI_RW_Reg(uchar reg, uchar value);
uint SPI_Read_Buf(uchar reg, uchar *pBuf, uchar uchars);
uint SPI_Write_Buf(uchar reg, uchar *pBuf, uchar uchars);
unsigned char nRF24L01_RxPacket(unsigned char* rx_buf);
void nRF24L01_TxPacket(unsigned char * tx_buf);
//*****************************************ԃfBC*****************************************
void Delay(unsigned int s)
{
	unsigned int i;
	for(i=0; i<s; i++);
	for(i=0; i<s; i++);
}
//******************************************************************************************
uint 	bdata sta;   //Xe[^XtO
sbit	RX_DR	=sta^6;
sbit	TX_DS	=sta^5;
sbit	MAX_RT	=sta^4;
/******************************************************************************************
/*x֐
/******************************************************************************************/
void inerDelay_us(unsigned char n)
{
	for(;n>0;n--)
		_nop_();
}
//****************************************************************************************
/*NRF24L01
//***************************************************************************************/
void init_NRF24L01(void)
{
    inerDelay_us(100);
 	CE=0;    // chip enable
 	CSN=1;   // Spi disable 
 	SCK=0;   // Spi clock line init high
	SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);    // [JAhX	
	SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, RX_ADDRESS, RX_ADR_WIDTH); // MAhX
	SPI_RW_Reg(WRITE_REG + EN_AA, 0x01);      //  `l0	ACKe
	SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x01);  //  MAhX̓`l0̂݋eA`lȏꍇPage21Q  
	SPI_RW_Reg(WRITE_REG + RF_CH, 0);        //   `l2.4GHZA󑗐Mv
	SPI_RW_Reg(WRITE_REG + RX_PW_P0, RX_PLOAD_WIDTH); //f[^MxݒAł32oCg
	SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);   		//M1MHZݒAMp[ő0dB
	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);   		 // RQ󑗐MA荞݉A16rbgCRCAM@\}

}
/****************************************************************************************************
/*֐Fuint SPI_RW(uint uchar)
/*@\FNRF24L01SPI݃^C~O
/****************************************************************************************************/
uint SPI_RW(uint uchar)
{
	uint bit_ctr;
   	for(bit_ctr=0;bit_ctr<8;bit_ctr++) // output 8-bit
   	{
		MOSI = (uchar & 0x80);         // output 'uchar', MSB to MOSI
		uchar = (uchar << 1);           // shift next bit into MSB..
		SCK = 1;                      // Set SCK high..
		uchar |= MISO;       		  // capture current MISO bit
		SCK = 0;            		  // ..then set SCK low again
   	}
    return(uchar);           		  // return read uchar
}
/****************************************************************************************************
/*֐Fuchar SPI_Read(uchar reg)
/*@\FNRF24L01SPI^C~O
/****************************************************************************************************/
uchar SPI_Read(uchar reg)
{
	uchar reg_val;
	
	CSN = 0;                // CSN low, initialize SPI communication...
	SPI_RW(reg);            // Select register to read from..
	reg_val = SPI_RW(0);    // ..then read registervalue
	CSN = 1;                // CSN high, terminate SPI communication
	
	return(reg_val);        // return register value
}
/****************************************************************************************************/
/*@\FNRF24L01ǂ/WX^֐
/****************************************************************************************************/
uint SPI_RW_Reg(uchar reg, uchar value)
{
	uint status;
	
	CSN = 0;                   // CSN low, init SPI transaction
	status = SPI_RW(reg);      // select register
	SPI_RW(value);             // ..and write value to it..
	CSN = 1;                   // CSN high again
	
	return(status);            // return nRF24L01 status uchar
}
/****************************************************************************************************/
/*֐Fuint SPI_Read_Buf(uchar reg, uchar *pBuf, uchar uchars)
/*@\: f[^ǂݎAregFWX^AhXGpBufF\ǂݎf[^AhXGucharsFf[^ǂݎ
/****************************************************************************************************/
uint SPI_Read_Buf(uchar reg, uchar *pBuf, uchar uchars)
{
	uint status,uchar_ctr;
	
	CSN = 0;                    		// Set CSN low, init SPI tranaction
	status = SPI_RW(reg);       		// Select register to write to and read status uchar
	
	for(uchar_ctr=0;uchar_ctr<uchars;uchar_ctr++)
		pBuf[uchar_ctr] = SPI_RW(0);    // 
	
	CSN = 1;                           
	
	return(status);                    // return nRF24L01 status uchar
}
/*********************************************************************************************************
/*֐Fuint SPI_Write_Buf(uchar reg, uchar *pBuf, uchar uchars)
/*@\: f[^݁FWX^AhXCpBufF\f[^݃AhXCucharsF݃f[^
/*********************************************************************************************************/
uint SPI_Write_Buf(uchar reg, uchar *pBuf, uchar uchars)
{
	uint status,uchar_ctr;
	
	CSN = 0;            //SPIL       
	status = SPI_RW(reg);   
	for(uchar_ctr=0; uchar_ctr<uchars; uchar_ctr++) //
		SPI_RW(*pBuf++);
	CSN = 1;           //SPIIt
	return(status);    // 
}
/****************************************************************************************************/
/*֐Fvoid SetRX_Mode(void)
/*@\Ff[^Mݒ 
/****************************************************************************************************/
void SetRX_Mode(void)
{
	CE=0;
	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0f);   		// IRQ󑗐MA荞݉A16rbgCRCAM@\
	CE = 1; 
	inerDelay_us(130);
}
/******************************************************************************************************/
/*֐Funsigned char nRF24L01_RxPacket(unsigned char* rx_buf)
/*@\Ff[^ǂݎ芮Arx_bufMobt@ɕۑ
/******************************************************************************************************/
unsigned char nRF24L01_RxPacket(unsigned char* rx_buf)
{
    unsigned char revale=0;
	sta=SPI_Read(STATUS);	// Xe[^XWX^ǂݎAf[^M󋵂𔻒f
	if(RX_DR)				// f[^M󋵔fi/sj
	{
	    CE = 0; 			//SPIL
		SPI_Read_Buf(RD_RX_PLOAD,rx_buf,TX_PLOAD_WIDTH);// read receive payload from RX_FIFO buffer
		revale =1;			//f[^tOǂݎ
	}
	SPI_RW_Reg(WRITE_REG+STATUS,sta);   //f[^MARX_DRATX_DSAMAX_PT̓nC1A荞݃tONA
	return revale;
}
/***********************************************************************************************************
/*֐Fvoid nRF24L01_TxPacket(unsigned char * tx_buf)
/*@\Ftx_buff[^M
/**********************************************************************************************************/
void nRF24L01_TxPacket(unsigned char * tx_buf)
{
	CE=0;			//StandBy I[h	
	SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH); // MAhX[h
	SPI_Write_Buf(WR_TX_PLOAD, tx_buf, TX_PLOAD_WIDTH); 			 // f[^[h	
//	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);   		 // IRQ󑗐MA荞݉A16rbgCRCAM@\
	CE=1;		 //CEnCAf[^M
	inerDelay_us(10);
}
//************************************C֐************************************************************
void main(void)
{
	uchar temp =0;	
    init_NRF24L01() ;
	led0=0;led1=0;led2=0;led3=0;
	P0=0x00;
	nRF24L01_TxPacket(TxBuf);	// Transmit Tx buffer data
	Delay(6000);
	P0=0xBF;
	while(1)
	{	
			if(temp<4)
		{
		switch(temp)
		{
		case 	1:	
			P0=	0xBF;
			break;	
		case 	2:	 
 	   	P0=	0xf7;
		
				break;	
		case 	3:
				P0=	0xFE;

		  	break;	
		default:  break;
		}
		}
	if(temp==3)
		{
		temp=0;
		}
		nRF24L01_TxPacket(TxBuf);	// Transmit Tx buffer data
		Delay(20000);
		SPI_RW_Reg(WRITE_REG+STATUS,0XFF);  
		temp++;
		}
	
}
