#ifndef __TFT018_H
#define __TFT018_H
#include "MyType.h"

#define LCD_WIDTH	160
#define LCD_HIGH	128

extern volatile U8 Font;

void BacklightOn(void);

/* LCD color */
#define White          0xFFFF
#define Black          0x0000
#define Blue           0x001F
#define Blue2          0x051F
#define Red            0xF800
#define Magenta        0xF81F
#define Green          0x07E0
#define Cyan           0x7FFF
#define Yellow         0xFFE0


/*----------------------------------------------------------*\
 | I/O DEFINE                                               |
\*----------------------------------------------------------*/
#define FIO1PIN2         (*((volatile unsigned long *) 0x3FFFC036))
#define FIO1DIR2         (*((volatile unsigned long *) 0x3FFFC022))

// Port 0
#define LCD_BUS_RST	(1<<3)
#define LCD_BUS_CS	(1<<2)
#define LCD_BUS_RD	(1<<22)
// Port 1
#define LCD_BUS_RS	(1<<25)
#define LCD_BUS_RW	(1<<24)
#define LCD_BUS_DAT	0x00FF0000

/*----------------------------------------------------------*\
 | BUS simulate                                             |
\*----------------------------------------------------------*/

/* ------ LOW LEVEL OPERATE ------ */
void LCD_Bus_Write_Byte( unsigned char Data );
void LCD_Reg_Set(unsigned int Cmd,unsigned int Data);


/*----------------------------------------------------------*\
 | HX8309A                                                  |
\*----------------------------------------------------------*/
void LCD_Init( void );
void LCD_SetArea( U8 x0, U8 y0, U8 x1, U8 y1 );

void LCD_Clear_Screen( unsigned int Data );
void LCD_Rectangle( unsigned short x0, unsigned short y0, unsigned short x1, unsigned short y1, unsigned int Data );
void LCD_SetPixel(unsigned short x, unsigned short y, unsigned short color);

void LCD_PutChar(unsigned short x, unsigned short y, char c, unsigned int f, unsigned int b);
void LCD_PutString(unsigned short x, unsigned short y, char *s, unsigned int f, unsigned int b);

void PutGB1616(unsigned short x, unsigned short  y, unsigned char c[2], unsigned int f,unsigned int b);
void LCD_BMP( U8 x0, U8 y0, U8 x1, U8 y1 , U16 * Bmp );

#endif

