/**************************************************
Function: SPI_RW();

Description:
  Writes one byte to nRF24L01, and return the byte read
  from nRF24L01 during write, according to SPI protocol
L8rbgWX^ɔ҂̃f[^10101010AオGbWMAGbWMAʗD摗MƉ肷B
ŏ̗オGbWŁAf[^sdo=1G
WX^101010101rbgVtgAE1rbg̖mxŕ⑫A0101010xƂȂB
GbWŁASDĨxWX^Ƀb`AWX^0101010sdiA
8̃NbNpXA2̃WX^̓e݊B1spi^C~OB

/**************************************************/
uchar SPI_RW(uchar byte)
{
	uchar bit_ctr;
   	for(bit_ctr=0;bit_ctr<8;bit_ctr++)   // output 8-bit    // 8rbgo
   	{
   		MOSI = (byte & 0x80);         // output 'byte', MSB to MOSI		   // MOSIsóAʂʂցABYTE ̍ōʂ1ȏꍇA_vZ1A1óG0ȏꍇA_vZ0A0óB
   		byte = (byte << 1);           // shift next bit into MSB..	    // 1rbgVtgAʂ獂ʂփVtgB
   		SCK = 1;                      // Set SCK high..	   // SCKsvAbv
   		byte |= MISO;       		  //byte=byte|MISO  capture current MISO bit	 	// MISOXe[^XrbgBYTEɕۑB
   		SCK = 0;            		  // ..then set SCK low again		// SCKsv_EA1rbgMB
   	}
    return(byte);           		  // return read byte	  	// Xe[^Xrbgɖ߂
}
/**************************************************/

/**************************************************
Function: SPI_RW_Reg();

Description:
  Writes value 'value' to register 'reg'
/**************************************************/
uchar SPI_RW_Reg(BYTE reg, BYTE value)
{
	uchar status;

  	CSN = 0;                   // CSN low, init SPI transaction	 // CS̓[xASPIMJn
  	status = SPI_RW(reg);      // select register  // R}hƃAhXM
  	SPI_RW(value);             // ..and write value to it..	 // 1 BYTEl
  	CSN = 1;                   // CSN high again    // SPIM

  	return(status);      // status@߂        // return nRF24L01 status byte
}
/**************************************************/

/**************************************************
Function: SPI_Read();

Description:
  Read one byte from nRF24L01 register, 'reg'
/**************************************************/
BYTE SPI_Read(BYTE reg)
{
	BYTE reg_val;

  	CSN = 0;                // CSN low, initialize SPI communication...  // CS̓[xASPIMJn
  	SPI_RW(reg);            // Select register to read from..  // ǂݎAhXݒ
  	reg_val = SPI_RW(0);    // ..then read registervalue	  // f[^ǂݎ
  	CSN = 1;                // CSN high, terminate SPI communication   // SPIM

  	return(reg_val);        // return register value	// f[^ԐM
}
/**************************************************/

/**************************************************
Function: SPI_Read_Buf();

Description:
  Reads 'bytes' #of bytes from register 'reg'
  Typically used to read RX payload, Rx/Tx address
/**************************************************/
uchar SPI_Read_Buf(BYTE reg, BYTE *pBuf, BYTE bytes)
{
	uchar status,byte_ctr;

  	CSN = 0;          	            // CS̓[xASPIMJn// Set CSN low, init SPI tranaction
  	status = SPI_RW(reg);         	// f[^MR}h𑗐M	   // Select register to write to and read status byte

  	for(byte_ctr=0;byte_ctr<bytes;byte_ctr++)
    pBuf[byte_ctr] = SPI_RW(0);      // 1 BYTEf[^ǂݎ   // Perform SPI_RW to read byte from nRF24L01

  	CSN = 1;                         // f[^M // Set CSN high again

  	return(status);                    // return nRF24L01 status byte
}
/**************************************************/

/**************************************************
Function: SPI_Write_Buf();

Description:
  Writes contents of buffer '*pBuf' to nRF24L01
  Typically used to write TX payload, Rx/Tx address
/**************************************************/
uchar SPI_Write_Buf(BYTE reg, BYTE *pBuf, BYTE bytes)
{
	uchar status,byte_ctr;

  	CSN = 0;               // CS̓[xASPIM  // Set CSN low, init SPI tranaction
  	status = SPI_RW(reg);  // f[^݃R}h𑗐M	  // Select register to write to and read status byte
  	for(byte_ctr=0; byte_ctr<bytes; byte_ctr++) // Mf[^` // then write all byte in buffer(*pBuf)
    	SPI_RW(*pBuf++);
  	CSN = 1;              // f[^M     // Set CSN high again
  	return(status);          // return nRF24L01 status byte
}
//֐ݒ
void NRF24L01_Config(void)
{
 //initial io
  CE=0;   //`bvL
  CSN=1; //SPI
  SCK=0; //SPINbNCvAbv
  CE=0;
  SPI_RW_Reg(WRITE_REG + CONFIG,0X0F);//ʓd[hACRC(2oCg)RX_DRL
  SPI_RW_Reg(WRITE_REG + EN_AA,0X3f);//`l0Aacke
  SPI_RW_Reg(WRITE_REG + EN_RXADDR,0X3f);//pipe0e
  SPI_RW_Reg(WRITE_REG + RF_CH, 0);        //  `l2.4GHZA󑗐MvƐݒ肷
  SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);   		//˃[g1MHZAő呗Mp[0dB	
  SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);   		 // IRQ󑗐M㉞IA16rbgCRCAM@\
  SPI_RW_Reg(WRITE_REG + RX_PW_P0, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
  SPI_RW_Reg(WRITE_REG + RX_PW_P1, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
  SPI_RW_Reg(WRITE_REG + RX_PW_P2, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
  SPI_RW_Reg(WRITE_REG + RX_PW_P3, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
  SPI_RW_Reg(WRITE_REG + RX_PW_P4, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
  SPI_RW_Reg(WRITE_REG + RX_PW_P5, RX_PLOAD_WIDTH); //Mf[^ݒAł32oCg
//SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);    // 
  SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);    // [JAhX	
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, RX_ADDRESS, RX_ADR_WIDTH); // MAhX0
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P1, RX_ADDRESS1, RX_ADR_WIDTH); // MAhX1
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P2, RX_ADDRESS2, 1); // MAhX2
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P3, RX_ADDRESS3, 1); // MAhX3
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P4, RX_ADDRESS4, 1); // MAhX4
  SPI_Write_Buf(WRITE_REG + RX_ADDR_P5, RX_ADDRESS5, 1); // MAhX5
  SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);   		 // IRQ󑗐M㉞IA16rbgCRCAM@\
  CE=1;/////////////
}

/////f[^M
BYTE NRF24L01_RxPacket(BYTE *rx_buf)
{
  uchar revale=0;
  SPI_RW_Reg(WRITE_REG + CONFIG,0X0F);
  CE=1;
  delay_ms(10);
  sta=SPI_Read(STATUS);
  if(RX_DR)
  {
  	CE=0;
	SPI_Read_Buf(RD_RX_PLOAD,rx_buf,TX_PLOAD_WIDTH);
    revale=1; 
  }
 SPI_RW_Reg(WRITE_REG + STATUS,sta);
 return revale;
}
//f[^M







/**************************************************/

/**************************************************
Function: RX_Mode();

Description:
  This function initializes one nRF24L01 device to
  RX Mode, set RX address, writes RX payload width,
  select RF channel, datarate & LNA HCURR.
  After init, CE is toggled high, which means that
  this device is now ready to receive a datapacket.
/**************************************************/
/*
void RX_Mode(void)
{
	CE=0;
 
  	SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH); // Use the same address on the RX device as the TX device

  	SPI_RW_Reg(WRITE_REG + EN_AA, 0x01);      // Enable Auto.Ack:Pipe0
  	SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x01);  // Enable Pipe0
  	SPI_RW_Reg(WRITE_REG + RF_CH, 40);        // Select RF channel 40
  	SPI_RW_Reg(WRITE_REG + RX_PW_P0, TX_PLOAD_WIDTH); // Select same RX payload width as TX Payload width
  	SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);   // TX_PWR:0dBm, Datarate:2Mbps, LNA:HCURR
  	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0f);     // Set PWR_UP bit, enable CRC(2 bytes) & Prim:RX. RX_DR enabled..

  	CE = 1; // Set CE pin high to enable RX device
	delay_ms(10);
	CE=0;
  //  This device is now ready to receive one packet of 16 bytes payload from a TX device sending to address
  //  '3443101001', with auto acknowledgment, retransmit count of 10, RF channel 40 and datarate = 2Mbps.

}	*/
/**************************************************/

/**************************************************
Function: TX_Mode();

Description:
  This function initializes one nRF24L01 device to
  TX mode, set TX address, set RX address for auto.ack,
  fill TX payload, select RF channel, datarate & TX pwr.
  PWR_UP is set, CRC(2 bytes) is enabled, & PRIM:TX.

  ToDo: One high pulse(>10us) on CE will now send this
  packet and expext an acknowledgment from the RX device.
/**************************************************/
/*
void TX_Mode(void)
{
	CE=0;

  	SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);    // Writes TX_Address to nRF24L01
  	SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH); // RX_Addr0 same as TX_Adr for Auto.Ack
  	SPI_Write_Buf(WR_TX_PLOAD, tx_buf, TX_PLOAD_WIDTH); // Writes data to TX payload

  	SPI_RW_Reg(WRITE_REG + EN_AA, 0x01);      // Enable Auto.Ack:Pipe0
  	SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x01);  // Enable Pipe0
  	SPI_RW_Reg(WRITE_REG + SETUP_RETR, 0x1a); // 500us + 86us, 10 retrans...
  	SPI_RW_Reg(WRITE_REG + RF_CH, 40);        // Select RF channel 40
  	SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);   // TX_PWR:0dBm, Datarate:2Mbps, LNA:HCURR
  	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);     // Set PWR_UP bit, enable CRC(2 bytes) & Prim:TX. MAX_RT & TX_DS enabled..
	
	CE=1;
	delay_ms(10);
	CE=0;
} */
/**************************************************/

/**************************************************
Function: check_ACK();

Description:
  check if have "Data sent TX FIFO interrupt",if TX_DS=1,
  all led light and after delay 100ms all led close
/**************************************************/
void check_ACK()
{
	uchar test;
	test=SPI_Read(READ_REG+STATUS);	// read register STATUS's
	test=test&0x20;					// check if have Data sent TX FIFO interrupt (TX_DS=1)
	if(test==0x20)					// TX_DS =1
	{
		L1=1;					
	    delay_ms(100);					// delay 100ms
		L1=0;
	}
}