#include "stm32f10x.h"
#include "init.h"
#include "uart.h"
#include "main.h"


void GPIO_Configuration(void)
{
#ifdef HGD_B	 //BGPIO
 	GPIOA->CRL=0XBBB33333;
	GPIOA->CRH=0X333334B3;
	GPIOB->CRL=0X44333433;
	GPIOB->CRH=0X3333B437;
	GPIOC->CRL=0X3333F430;
	GPIOC->CRH=0X44433333;
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE );
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_NoJTRST, ENABLE );
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_Disable, ENABLE );	 
#elif defined HGD_E	  //EGPIO
	
	GPIOA->CRL=0XBBB33333;
	GPIOA->CRH=0X444334B3;

	GPIOB->CRL=0X44744433;
	GPIOB->CRH=0X4444B433;

	GPIOC->CRL=0X44044444;
	GPIOC->CRH=0X44434444;

  	GPIOD->CRL=0XBBBB34BB;
	GPIOD->CRH=0XBBBBBBBB;

	GPIOE->CRL=0XB4BBB4BB;
	GPIOE->CRH=0XBBBBBBBB;

	GPIOF->CRL=0X43BBBBBB;
	GPIOF->CRH=0XBBBB4444;

	GPIOG->CRL=0X33BBBBBB;
	GPIOG->CRH=0X444B4BB4;	  
#else  //ƿ
	GPIOA->CRL=0XBBB33333;
	GPIOA->CRH=0X444334B3;	 	
#endif
}
//ϵͳжϹ
void NVIC_Configuration(void)
{
  NVIC_InitTypeDef NVIC_InitStructure; 
  /* Configure the NVIC Preemption Priority Bits */  
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_0);
  
  /* Enable the USARTy Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);

}
//ϵͳʱ,ʹܸʱ
void RCC_Configuration(void)
{
	SystemInit();	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA 
                           |RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC
                           |RCC_APB2Periph_GPIOD | RCC_APB2Periph_ADC1
                           | RCC_APB2Periph_AFIO |
                           RCC_APB2Periph_SPI1, ENABLE );
  // RCC_APB2PeriphClockCmd(RCC_APB2Periph_ALL ,ENABLE );
     RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4 
                           |RCC_APB1Periph_USART3|RCC_APB1Periph_TIM2	                           
                           , ENABLE );
	 RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
}
//
void Init_All_Periph(void)
{
	RCC_Configuration();
	NVIC_Configuration();
	GPIO_Configuration();
	USART1_Configuration();
}
//ͿϢ
void SendStartMessage(void)
{ 
   UART1Write((u8*)"Starting.....",sizeof("Starting.....")) ;
}

