/*
Ϊһ24C02
*/

#include "stm32f10x.h"
#include "I2C.h"

//#define AT24C01A		//24C01A,I2Cʱ24C02һ
#define AT24C01		//24C01,I2Cʱͨе㲻ͬ

#define EEPROM_ADDR		0xA0
#define I2C_PAGESIZE	4		//24C01/01Aҳ4


void I2C_Configuration(void)
{
	I2C_InitTypeDef  I2C_InitStructure;
	GPIO_InitTypeDef  GPIO_InitStructure; 

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_I2C1,ENABLE);

	/* PB6,7 SCL and SDA */
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_6 | GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_OD;
	GPIO_Init(GPIOB, &GPIO_InitStructure);
	
    I2C_DeInit(I2C1);
    I2C_InitStructure.I2C_Mode = I2C_Mode_I2C;
    I2C_InitStructure.I2C_DutyCycle = I2C_DutyCycle_2;
    I2C_InitStructure.I2C_OwnAddress1 = 0x30;
    I2C_InitStructure.I2C_Ack = I2C_Ack_Enable;
    I2C_InitStructure.I2C_AcknowledgedAddress = I2C_AcknowledgedAddress_7bit;
    I2C_InitStructure.I2C_ClockSpeed = 100000;//100Kٶ
    
	I2C_Cmd(I2C1, ENABLE);
	I2C_Init(I2C1, &I2C_InitStructure);
	/*1ֽ1Ӧģʽ*/
	I2C_AcknowledgeConfig(I2C1, ENABLE);

}

/***************************************************
**:I2C_ReadS
**:ȡ24C02ֽ
**ע:24C02256ֽ,8λַ,A0-A2̶Ϊ0,ַΪEEPROM_ADDR
***************************************************/
void I2C_ReadS_24C(u8 addr ,u8* pBuffer,u16 no)
{
    if(no==0)
		return;
	
	while(I2C_GetFlagStatus(I2C1, I2C_FLAG_BUSY));
		
	/*1ֽ1Ӧģʽ*/
	I2C_AcknowledgeConfig(I2C1, ENABLE);


	/* ʼλ */
    I2C_GenerateSTART(I2C1, ENABLE);
    while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_MODE_SELECT));/*EV5,ģʽ*/

#ifdef AT24C01A	
    /*ַ(д)*/
    I2C_Send7bitAddress(I2C1,  EEPROM_ADDR, I2C_Direction_Transmitter);
    while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED));

	/*͵ַ*/
	I2C_SendData(I2C1, addr);
    while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTED));/*ѷ*/
		
	/*ʼλ*/
	I2C_GenerateSTART(I2C1, ENABLE);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_MODE_SELECT));
	
	/**/
	I2C_Send7bitAddress(I2C1, EEPROM_ADDR, I2C_Direction_Receiver);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_RECEIVER_MODE_SELECTED));
	
	
#else	
	/*ַ()24C01*/
	I2C_Send7bitAddress(I2C1, addr<<1, I2C_Direction_Receiver);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_RECEIVER_MODE_SELECTED));
#endif
	
    while (no)
    {
		if(no==1)
		{
     		I2C_AcknowledgeConfig(I2C1, DISABLE);	//һλҪرӦ
    		I2C_GenerateSTOP(I2C1, ENABLE);			//ֹͣλ
		}
	    
		while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_RECEIVED)); /* EV7 */
	    *pBuffer = I2C_ReceiveData(I2C1);
	    pBuffer++;
	    /* Decrement the read bytes counter */
	    no--;
    }
	//ٴӦģʽ
	I2C_AcknowledgeConfig(I2C1, ENABLE);
}

/****************************************************
**:I2C_Standby_24C
**:24CǷ׼дж
**ע:Ϊ:æ
****************************************************/
void I2C_Standby_24C(void)      
{
  vu16 SR1_Tmp;
  do
  {
    /*ʼλ*/
    I2C_GenerateSTART(I2C1, ENABLE);
    /*SR1*/
    SR1_Tmp = I2C_ReadRegister(I2C1, I2C_Register_SR1);
    /*ַ(д)*/
    #ifdef AT24C01A
	I2C_Send7bitAddress(I2C1, EEPROM_ADDR, I2C_Direction_Transmitter);
	#else
	I2C_Send7bitAddress(I2C1, 0, I2C_Direction_Transmitter);
	#endif
  }while(!(I2C_ReadRegister(I2C1, I2C_Register_SR1) & 0x0002));
  
  /**/
  I2C_ClearFlag(I2C1, I2C_FLAG_AF);
  /*ֹͣλ*/    
  I2C_GenerateSTOP(I2C1, ENABLE);
}

/*************************************************
**:I2C_ByteWrite_24C
**:дһֽ
**ע:дͬҪæж
*************************************************/
void I2C_ByteWrite_24C(u8 addr,u8 dat)
{
  /* ʼλ */
  	I2C_GenerateSTART(I2C1, ENABLE);
  	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_MODE_SELECT));  

#ifdef AT24C01A
  	/* ַ(д)*/
  	I2C_Send7bitAddress(I2C1, EEPROM_ADDR, I2C_Direction_Transmitter);
  	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED));
  
  	/*͵ַ*/
  	I2C_SendData(I2C1, addr);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTED));

#else	
	I2C_Send7bitAddress(I2C1, addr<<1, I2C_Direction_Transmitter);
 	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED));
#endif

	/* дһֽ*/
  	I2C_SendData(I2C1, dat); 
  	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTED));
	
  	/* ֹͣλ*/
  	I2C_GenerateSTOP(I2C1, ENABLE);
  
  	I2C_Standby_24C();
}

/*************************************************
**:I2C_PageWrite_24C
**:дһҳ()
**ע:˺Ⱥд
*************************************************/
void I2C_PageWrite_24C(u8 addr,u8* pBuffer, u8 no)
{
	while(I2C_GetFlagStatus(I2C1, I2C_FLAG_BUSY));

	/*ʼλ*/
	I2C_GenerateSTART(I2C1, ENABLE);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_MODE_SELECT)); 

#ifdef AT24C01A
	/*ַ(д)*/
	I2C_Send7bitAddress(I2C1, EEPROM_ADDR, I2C_Direction_Transmitter);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED));
	
	/*дֵַ*/
	I2C_SendData(I2C1, addr);
	while(! I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTED));

#else
	I2C_Send7bitAddress(I2C1, addr<<1, I2C_Direction_Transmitter);
	while(!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED)); 
#endif
	while(no--)  
	{
	  I2C_SendData(I2C1, *pBuffer); 
	  pBuffer++; 
	  while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTED));
	}
	
	/*ֹͣλ*/
	I2C_GenerateSTOP(I2C1, ENABLE);
}



/*************************************************
**:I2C_WriteS_24C
**:ҳд24C
**ע:24C02һд8ֽ
*************************************************/
void I2C_WriteS_24C(u8 addr,u8* pBuffer,  u16 no)
{
	u8 temp;

	//1.ȰҳĲд
	temp=addr % I2C_PAGESIZE;
	if(temp)
	{
		temp=I2C_PAGESIZE-temp;
		I2C_PageWrite_24C(addr,pBuffer,  temp);
		no-=temp;
		addr+=temp;
		pBuffer+=temp;
		I2C_Standby_24C();
	}
	//2.ҳ뿪ʼд
	while(no)
	{
		if(no>=I2C_PAGESIZE)
		{
			I2C_PageWrite_24C(addr,pBuffer,  I2C_PAGESIZE);
			no-=I2C_PAGESIZE;
			addr+=I2C_PAGESIZE;
			pBuffer+=I2C_PAGESIZE;
			I2C_Standby_24C();
		}
		else
		{
			I2C_PageWrite_24C(addr,pBuffer,  no);
			no=0;
			I2C_Standby_24C();
		}
	}
}


//
void I2C_Test(void)
{
	u8 i;
	u8 I2c_Buf[128];

	I2C_Standby_24C();
	
	//仺
	for(i=0;i<128;i++)
		I2c_Buf[i]=i;
		
	//д
	I2C_WriteS_24C(1,I2c_Buf,120);
	
	//建
	for(i=0;i<128;i++)
		I2c_Buf[i]=0;
		
	//
	I2C_ReadS_24C(1,I2c_Buf,120);
	
	for(i=1;i<120;i++)
	{	
		if(I2c_Buf[i]!=i)
		{
			while(1);
		}
	}

}

