#include "stm32f10x.h"
#include "GLCD.h"
#include "USART.h"

void GPIO_Configuration(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	/* Configure DAC channe1 and DAC channel2 outputs pins */
  	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_4 | GPIO_Pin_5;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);

   	/* Configure USART1 Tx (PA.09) as alternate function push-pull */
  	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);
    
  	/* Configure USART1 Rx (PA.10) as input floating */
  	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);
}

//ϵͳжϹ
void NVIC_Configuration(void)
{ 
  	/* Configure the NVIC Preemption Priority Bits */  
  	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_0);

	#ifdef  VECT_TAB_RAM  
	  /* Set the Vector Table base location at 0x20000000 */ 
	  NVIC_SetVectorTable(NVIC_VectTab_RAM, 0x0); 
	#else  /* VECT_TAB_FLASH  */
	  /* Set the Vector Table base location at 0x08000000 */ 
	  NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x0);   
	#endif
}

//ϵͳʱ,ʹܸʱ
void RCC_Configuration(void)
{
	SystemInit();	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA 
                           |RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC
                           |RCC_APB2Periph_GPIOD | RCC_APB2Periph_GPIOE
						   |RCC_APB2Periph_ADC1  | RCC_APB2Periph_AFIO 
                           |RCC_APB2Periph_SPI1, ENABLE );
  // RCC_APB2PeriphClockCmd(RCC_APB2Periph_ALL ,ENABLE );
     RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4 
                           |RCC_APB1Periph_USART3|RCC_APB1Periph_TIM2	                           
                           , ENABLE );
	 RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);

	 /* Enable peripheral clocks --------------------------------------------------*/
  	/* DMA clock enable */
  	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA2, ENABLE);
  	/* AFIO and GPIOA Periph clock enable */
  	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO | RCC_APB2Periph_GPIOA, ENABLE);
  	/* DAC Periph clock enable */
  	RCC_APB1PeriphClockCmd(RCC_APB1Periph_DAC, ENABLE);
  	/* TIM8 Periph clock enable */
  	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM8, ENABLE);
}

void InitDis(void) 
{
   /* LCD Module init */
   GLCD_init();
   GLCD_clear(White);
   GLCD_setTextColor(Blue);
   GLCD_displayStringLn(Line1, "     GoldBull");
   GLCD_displayStringLn(Line2, "   DAC example");
   GLCD_setTextColor(Red);
}

//
void Init_All_Periph(void)
{
	RCC_Configuration();	
	InitDis();
//	GLCD_Test();
	GPIO_Configuration();
	NVIC_Configuration();
	USART1_Configuration();
	USART1Write((u8*)"    GoldBull  ADC_example ",sizeof("    GoldBull  DAC_example "));
}

#define DAC_DHR12RD_Address      0x40007420

/* Init Structure definition */
DAC_InitTypeDef            DAC_InitStructure;
DMA_InitTypeDef            DMA_InitStructure;
TIM_TimeBaseInitTypeDef    TIM_TimeBaseStructure;

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
ErrorStatus HSEStartUpStatus;
uc16 Sine12bit[32] = {2047, 2447, 2831, 3185, 3498, 3750, 3939, 4056, 4095, 4056,
                      3939, 3750, 3495, 3185, 2831, 2447, 2047, 1647, 1263, 909, 
                      599, 344, 155, 38, 0, 38, 155, 344, 599, 909, 1263, 1647};

u32 DualSine12bit[32];
u8 Idx = 0;

int main(void)
{  
	Init_All_Periph();

	/* TIM8 Configuration */
  	/* Time base configuration */
  	TIM_TimeBaseStructInit(&TIM_TimeBaseStructure); 
  	TIM_TimeBaseStructure.TIM_Period = 0x19;          
  	TIM_TimeBaseStructure.TIM_Prescaler = 0x0;       
  	TIM_TimeBaseStructure.TIM_ClockDivision = 0x0;    
  	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;  
  	TIM_TimeBaseInit(TIM8, &TIM_TimeBaseStructure);

  	/* TIM8 TRGO selection */
  	TIM_SelectOutputTrigger(TIM8, TIM_TRGOSource_Update);

  	/* DAC channel1 Configuration */
  	DAC_InitStructure.DAC_Trigger = DAC_Trigger_T8_TRGO;
 	DAC_InitStructure.DAC_WaveGeneration = DAC_WaveGeneration_None;
  	DAC_InitStructure.DAC_OutputBuffer = DAC_OutputBuffer_Disable;
  	DAC_Init(DAC_Channel_1, &DAC_InitStructure);

  	/* DAC channel2 Configuration */
  	DAC_Init(DAC_Channel_2, &DAC_InitStructure);

  	/* Fill Sine32bit table */
  	for (Idx= 0; Idx<32; Idx++)
  	{
    	DualSine12bit[Idx] = (Sine12bit[Idx] << 16) + (Sine12bit[Idx]);
  	}

  	/* DMA2 channel4 configuration */
  	DMA_DeInit(DMA2_Channel4);
  	DMA_InitStructure.DMA_PeripheralBaseAddr = DAC_DHR12RD_Address;
  	DMA_InitStructure.DMA_MemoryBaseAddr = (u32)&DualSine12bit;
  	DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralDST;
  	DMA_InitStructure.DMA_BufferSize = 32;
  	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
  	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
  	DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_Word;
  	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_Word;
  	DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
  	DMA_InitStructure.DMA_Priority = DMA_Priority_High;
  	DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
  	DMA_Init(DMA2_Channel4, &DMA_InitStructure);

  	/* Enable DMA2 Channel4 */
  	DMA_Cmd(DMA2_Channel4, ENABLE);

  	/* Enable DAC Channel1 */
 	 DAC_Cmd(DAC_Channel_1, ENABLE);
  	/* Enable DAC Channel2 */
  	DAC_Cmd(DAC_Channel_2, ENABLE);

  	/* Enable DMA for DAC Channel2 */
  	DAC_DMACmd(DAC_Channel_2, ENABLE);

  	/* TIM8 enable counter */
  	TIM_Cmd(TIM8, ENABLE);
 	while(1)
  	{
		
  	}
}


