#include "ov7660.h"

const unsigned char ov7670_regs[][2] = 
 {
 	{0x3a, 0x04},
	{0x40, 0xd0},

	{0x11, 0xff},
	{0x12, 0x14},
	{0x32, 0x80},
	{0x17, 0x16},
	{0x18, 0x04},
	{0x19, 0x02},
	{0x1a, 0x7b},
	{0x03, 0x06},
	{0x0c, 0x04},
	{0x3e, 0x19},
	{0x70, 0x3a},
	{0x71, 0x35},
	{0x72, 0x11},
	{0x73, 0xf1},
	{0xa2, 0x02},
	
	{0x7a, 0x20},
	{0x7b, 0x1c},
	{0x7c, 0x28},
	{0x7d, 0x3c},
	{0x7e, 0x55},
	{0x7f, 0x68},
	{0x80, 0x76},
	{0x81, 0x80},
	{0x82, 0x88},
	{0x83, 0x8f},
	{0x84, 0x96},
	{0x85, 0xa3},
	{0x86, 0xaf},
	{0x87, 0xc4},
	{0x88, 0xd7},
	{0x89, 0xe8},
	
	{0x13, 0xe0},
	{0x00, 0x00},
	{0x10, 0x00},
	{0x0d, 0x40},
	{0x14, 0x28},
	{0xa5, 0x05},
	{0xab, 0x07},
	{0x24, 0x65},
	{0x25, 0x33},
	{0x26, 0xe3},
	{0x9f, 0x78},
	{0xa0, 0x68},
	{0xa1, 0x03},
	{0xa6, 0xdf},
	{0xa7, 0xdf},
	{0xa8, 0xf0},
	{0xa9, 0x90},
	{0xaa, 0x94},
	{0x13, 0xe5},

	{0x0e, 0x61},
	{0x0f, 0x4b},
	{0x16, 0x02},
	{0x1e, 0x37},
	{0x21, 0x02},
	{0x22, 0x91},
	{0x29, 0x07},
	{0x33, 0x0b},
	{0x35, 0x0b},
	{0x37, 0x1d},
	{0x38, 0x71},
	{0x39, 0x2a},
	{0x3c, 0x78},
	{0x4d, 0x40},
	{0x4e, 0x20},
	{0x69, 0x00},
	{0x6b, 0x4a},
	{0x74, 0x19},
	{0x8d, 0x4f},
	{0x8e, 0x00},
	{0x8f, 0x00},
	{0x90, 0x00},
	{0x91, 0x00},
	{0x92, 0x00},
	{0x96, 0x00},
	{0x9a, 0x80},
	{0xb0, 0x84},
	{0xb1, 0x0c},
	{0xb2, 0x0e},
	{0xb3, 0x82},
	{0xb8, 0x0a},



	{0x43, 0x14},
	{0x44, 0xf0},
	{0x45, 0x34},
	{0x46, 0x58},
	{0x47, 0x28},
	{0x48, 0x3a},
	{0x59, 0x88},
	{0x5a, 0x88},
	{0x5b, 0x44},
	{0x5c, 0x67},
	{0x5d, 0x49},
	{0x5e, 0x0e},
	{0x64, 0x04},
	{0x65, 0x20},
	{0x66, 0x05},
	{0x94, 0x04},
	{0x95, 0x08},
	{0x6c, 0x0a},
	{0x6d, 0x55},
	{0x6e, 0x11},
	{0x6f, 0x9f},
	{0x6a, 0x40},
	{0x01, 0x40},
	{0x02, 0x40},
	{0x13, 0xe7},
	
	{0x4f, 0x80},
	{0x50, 0x80},
	{0x51, 0x00},
	{0x52, 0x22},
	{0x53, 0x5e},
	{0x54, 0x80},
	{0x58, 0x9e},
	
	{0x41, 0x08},
	{0x3f, 0x00},
	{0x75, 0x05},
	{0x76, 0xe1},
	{0x4c, 0x00},
	{0x77, 0x01},
	{0x3d, 0xc2},	
	{0x4b, 0x09},
	{0xc9, 0x60},
	{0x41, 0x38},
	{0x56, 0x45},
	
	{0x34, 0x11},
	{0x3b, 0x02},
	{0xa4, 0x89},
	{0x96, 0x00},
	{0x97, 0x30},
	{0x98, 0x20},
	{0x99, 0x30},
	{0x9a, 0x84},
	{0x9b, 0x29},
	{0x9c, 0x03},
	{0x9d, 0x4c},
	{0x9e, 0x3f},
	{0x78, 0x04},
	
	{0x79, 0x01},
	{0xc8, 0xf0},
	{0x79, 0x0f},
	{0xc8, 0x00},
	{0x79, 0x10},
	{0xc8, 0x7e},
	{0x79, 0x0a},
	{0xc8, 0x80},
	{0x79, 0x0b},
	{0xc8, 0x01},
	{0x79, 0x0c},
	{0xc8, 0x0f},
	{0x79, 0x0d},
	{0xc8, 0x20},
	{0x79, 0x09},
	{0xc8, 0x80},
	{0x79, 0x02},
	{0xc8, 0xc0},
	{0x79, 0x03},
	{0xc8, 0x40},
	{0x79, 0x05},
	{0xc8, 0x30},
	{0x79, 0x26},
	
	{0x3b, 0xc2}	   

 };

 void CLK_init_ON(void)
{
  
    GPIO_InitTypeDef GPIO_InitStructure;
    //ʱӵtxz
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8; 
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP ; 
    GPIO_Init(GPIOA, &GPIO_InitStructure);
    RCC_MCOConfig(RCC_MCO_HSE  );//hsi
}
void CLK_init_OFF(void)
{
  
    GPIO_InitTypeDef GPIO_InitStructure;
    //ʱӵtxz
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8; 
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz; 
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_Init(GPIOA, &GPIO_InitStructure);
    //RCC_MCOConfig(RCC_MCO_HSE  );//hsi
}

////////////////////////////
//ܣдOV7660Ĵ
//أ1-ɹ	0-ʧ
u8 wrOV7660Reg(u8 regID, u8 regDat)
{
	startSCCB();
	if(0==SCCBwriteByte(0x42))
	{
		stopSCCB();
		return(0);
	}
	DelaySCCB();
  	if(0==SCCBwriteByte(regID))
	{
		stopSCCB();
		return(0);
	}
	DelaySCCB();
  	if(0==SCCBwriteByte(regDat))
	{
		stopSCCB();
		return(0);
	}
  	stopSCCB();
	
  	return(1);
}
////////////////////////////
//ܣOV7660Ĵ
//أ1-ɹ	0-ʧ
u8 rdOV7660Reg(u8 regID, u8 *regDat)
{
	//ͨдüĴַ
	startSCCB();
	if(0==SCCBwriteByte(0x42))
	{
		stopSCCB();
		return(0);
	}
	DelaySCCB();
  	if(0==SCCBwriteByte(regID))
	{
		stopSCCB();
		return(0);
	}
	stopSCCB();
	
	DelaySCCB();
	
	//üĴַ󣬲Ƕ
	startSCCB();
	if(0==SCCBwriteByte(0x43))
	{
		stopSCCB();
		return(0);
	}
	DelaySCCB();
  	*regDat=SCCBreadByte();
  	noAck();
  	stopSCCB();
  	return(1);
}


//(140,16,640,480) is good for VGA
//(272,16,320,240) is good for QVGA
/* config_OV7660_window */
void OV7660_config_window(u16 startx,u16 starty,u16 width, u16 height)
{
	u16 endx=(startx+width);
	u16 endy=(starty+height*2);// "v*2"
	u8 temp_reg1, temp_reg2;
	u8 state,temp;
	
	state = rdOV7660Reg(0x03, &temp_reg1 );
	temp_reg1 &= 0xC0;
	state = rdOV7660Reg(0x32, &temp_reg2 );
	temp_reg2 &= 0xC0;
	
	// Horizontal
	temp = temp_reg2|((endx&0x7)<<3)|(startx&0x7);
	state = wrOV7660Reg(0x32, temp );
	temp = (startx&0x7F8)>>3;
	state = wrOV7660Reg(0x17, temp );
	temp = (endx&0x7F8)>>3;
	state = wrOV7660Reg(0x18, temp );
	
	// Vertical
	temp = temp_reg1|((endy&0x7)<<3)|(starty&0x7);
	state = wrOV7660Reg(0x03, temp );
	temp = (starty&0x7F8)>>3;
	state = wrOV7660Reg(0x19, temp );
	temp = (endy&0x7F8)>>3;
	state = wrOV7660Reg(0x1A, temp );
	if(state==0){}
}

void my_delay_ms(u16 time)//delay some time
{
	u16 i;
	for(;time!=0;time--)
	{
		for(i=0;i<10000;i++);
	}
}

u8 rt;
/* OV7660_init() */
//1ɹ0ʧ
u8 OV7660_init(void)
{
	u8 temp;
	u8 i;
        
	u8 ovidmsb=0;
	u8 ovidlsb=0;
	
	InitSCCB();//io init..

	temp=0x80;
	if(0==wrOV7660Reg(0x12, temp)) //Reset SCCB
	{
	  return 0;
	}
	my_delay_ms(100);
	
	rt = rdOV7660Reg(0x0a, &ovidmsb );
	if(ovidmsb !=0x76)
	{
		return 0;
	}
	
	rdOV7660Reg(0x0b, &ovidlsb );
	if(ovidlsb !=0x73)
	{
		return 0;
	}	

	for(i=0;i<sizeof(ov7670_regs)/sizeof(ov7670_regs[0])/2;i++)
	{
		if( 0==wrOV7660Reg(ov7670_regs[i][0],ov7670_regs[i][1]))
		{
			return 0;
		}
	}

        //OV7660_config_window(140,16,640,480);//(140,16,640,480) is good for VGA
//	OV7660_config_window(272,16,320,240);// set 240*320
	
	my_delay_ms(200);	
	
	return 0x01; //ok
} 
