#include "stm32f10x.h"
#include "SCCB.h"
#include "ov7660.h"
#include "GLCD.h"

GPIO_InitTypeDef GPIO_InitStructure;
EXTI_InitTypeDef EXTI_InitStructure;
NVIC_InitTypeDef NVIC_InitStructure;

void GPIO_Configuration(void)
{
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 |GPIO_Pin_3 | GPIO_Pin_4 | GPIO_Pin_5 | GPIO_Pin_6 |GPIO_Pin_7;								  
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GPIOD, &GPIO_InitStructure);
	
	//PB0,1Ϊж                         
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GPIOB, &GPIO_InitStructure);

	//PC5Ϊж  
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GPIOC, &GPIO_InitStructure);
   
    GPIO_EXTILineConfig(GPIO_PortSourceGPIOC, GPIO_PinSource5);
     // Configure EXTI Line5 to generate an interrupt on falling edge 
    EXTI_InitStructure.EXTI_Line = EXTI_Line5;
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
    
    GPIO_EXTILineConfig(GPIO_PortSourceGPIOB, GPIO_PinSource0);
     // Configure EXTI Line9 to generate an interrupt on falling edge 
    EXTI_InitStructure.EXTI_Line = EXTI_Line0;
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
    
    GPIO_EXTILineConfig(GPIO_PortSourceGPIOB, GPIO_PinSource1);
  
    // Configure EXTI Line9 to generate an interrupt on falling edge
    EXTI_InitStructure.EXTI_Line = EXTI_Line1;
    EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);

}
//ϵͳжϹ
void NVIC_Configuration(void)
{ 
  	/* Configure the NVIC Preemption Priority Bits */  
  	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_0);
  
    /* Enable the EXTI5 Interrupt on PC.5 */
    NVIC_InitStructure.NVIC_IRQChannel = EXTI9_5_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
      /* Enable the EXTI0 Interrupt on PB.0 */
    NVIC_InitStructure.NVIC_IRQChannel = EXTI0_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
    
    /* Enable the EXTI1 Interrupt on PB.1 */
    NVIC_InitStructure.NVIC_IRQChannel = EXTI1_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

}
//ϵͳʱ,ʹܸʱ
void RCC_Configuration(void)
{
	SystemInit();	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA 
                           |RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC
                           |RCC_APB2Periph_GPIOD | RCC_APB2Periph_GPIOE
						   |RCC_APB2Periph_ADC1  | RCC_APB2Periph_AFIO 
                           |RCC_APB2Periph_SPI1, ENABLE );
  // RCC_APB2PeriphClockCmd(RCC_APB2Periph_ALL ,ENABLE );
     RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4 
                           |RCC_APB1Periph_USART3|RCC_APB1Periph_TIM2	                           
                           , ENABLE );
	 RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
}

void InitDis(void) 
{
   /* LCD Module init */
   GLCD_init();
   GLCD_clear(White);
   GLCD_setTextColor(Blue);
   GLCD_displayStringLn(Line1, "       GoldBull");
   GLCD_displayStringLn(Line2, "    Camera example");
}

//
void Init_All_Periph(void)
{
	RCC_Configuration();	
	InitDis();
	while(1!=OV7660_init());//ʼov7660
	GLCD_Test();
	GPIO_Configuration();
//	NVIC_Configuration();
}
unsigned int flag1 = 0;
unsigned short dat_cam;
unsigned int row = 0,my_x = 0;

#define XCLK_H	        GPIOA->BSRR =  GPIO_Pin_8;;
#define XCLK_L		    GPIOA->BRR =   GPIO_Pin_8;;
u16 value = 0, val=0, RGB=0;
u32 aa = 0; 
u8 i = 0;
int main(void)
{  
	Init_All_Periph();
	GLCD_clear(0x0000);
	while (1)
	{
	
		value = GPIOC->IDR;
		if(value&0x0020)
		{
			wr_reg(0x20, 0);
  			wr_reg(0x21, 0);
			Clr_Cs;
			wr_cmd(0x22);
			CLK_init_OFF();
			while(aa < 76800)
			{
			 	XCLK_L;
        		XCLK_H;
			    value = GPIOB->IDR;
				RGB = 	GPIOD->IDR;
				i++;
				value = value&0x0001;
        		if(value>0)
				{
        			if(i==1)
          			{
            			val=RGB<<8;
          			}
          			else
          			{
           				val|=(RGB&0x00ff);
            			i=0;
            			wr_dat(val);
            			aa++;
          			}
         		}    
        	} 
			Set_Cs;
        	aa=0;
        	CLK_init_ON();
		}							
	}
	/*	
		wr_reg(0x20, 0);
  		wr_reg(0x21, row);	
		Clr_Cs;	  
	    wr_cmd(0x22);
		for(my_x=0;my_x<76800;my_x++)
		{
			if(my_x==319)
			{
			 	my_x = my_x;
			}
			wr_dat(0x0ff0);
		}
		Set_Cs;

		wr_reg(0x20, 200);
  		wr_reg(0x21, 10);
		Clr_Cs;
		wr_cmd(0x22);
		for(my_x=0;my_x<320;my_x++)
		{
			wr_dat(0xff00);
		}
		Set_Cs;
		if(++row>=239)
		{
			row = 0;
			GLCD_clear(0xff00);
		}		    				  */
}

void EXTI9_5_IRQHandler(void)  //HREF ͬ---  PC5 
{
	if(EXTI_GetITStatus(EXTI_Line5)!= RESET)//TXZ == 0
  	{
  		/* Clear the EXTI line 9 pending bit */
			    
	    row++;  	    
		Set_Cs;
		wr_reg(0x20, row);
  		wr_reg(0x21, 0);	    
	    Clr_Cs;	  
	    wr_cmd(0x22);
		Set_Rs;			      
	    flag1 = 0;	    
	    my_x = 0;
		
		EXTI_ClearITPendingBit(EXTI_Line5);
  	}	 
}

void EXTI0_IRQHandler(void)	   //VSYNC (֡ͬ) ---  PB0
{
	if(EXTI_GetITStatus(EXTI_Line0)!= RESET)//TXZ == 0
  	{
  		row = 0;	  
		EXTI_ClearITPendingBit(EXTI_Line0);
  	}
}
	  
void EXTI1_IRQHandler(void)	   //PCLK  (ʱ) ---  PB1
{
	if(EXTI_GetITStatus(EXTI_Line1)!= RESET)//TXZ == 0
  	{
  		if(my_x < 318)
	    {
	    
	      if(flag1 == 0)
	      {
	        dat_cam = ((GPIOD->IDR&0xff)<<8);
	        flag1 = 1;
	      }
	      else
	      {
	        GPIOE->ODR = dat_cam | (GPIOD->IDR&0xff);
	        Clr_nWr;
			Set_nWr;
	        flag1 = 0;
	        
	        my_x ++;
	      } 
	    }
		EXTI_ClearITPendingBit(EXTI_Line1);
  	}	 
}

