01 #
02 # (C) Copyright 2000-2006
03 # Wolfgang Denk, DENX Software Engineering, wd@denx.de.
04 #
05 # See file CREDITS for list of people who contributed to this
06 # project.
07 #
08 # This program is free software; you can redistribute it and/or
09 # modify it under the terms of the GNU General Public License as
10 # published by the Free Software Foundatio; either version 2 of
11 # the License, or (at your option) any later version.
12 #
13 # This program is distributed in the hope that it will be useful,
14 # but WITHOUT ANY WARRANTY; without even the implied warranty of
15 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
16 # GNU General Public License for more details.
17 #
18 # You should have received a copy of the GNU General Public License
19 # along with this program; if not, write to the Free Software
20 # Foundation, Inc., 59 Temple Place, Suite 330, Boston,
21 # MA 02111-1307 USA
22 #
23 
24 VERSION = 1
25 PATCHLEVEL = 1
26 SUBLEVEL = 6
27 EXTRAVERSION =
28 U_BOOT_VERSION = $(VERSION).$(PATCHLEVEL).$(SUBLEVEL)$(EXTRAVERSION)
29 VERSION_FILE = $(obj)include/version_autogenerated.h
30 
31 HOSTARCH := $(shell uname -m | \
32 	sed -e s/i.86/i386/ \
33 	    -e s/sun4u/sparc64/ \
34 	    -e s/arm.*/arm/ \
35 	    -e s/sa110/arm/ \
36 	    -e s/powerpc/ppc/ \
37 	    -e s/macppc/ppc/)
38 
39 HOSTOS := $(shell uname -s | tr '[:upper:]' '[:lower:]' | \
40 	    sed -e 's/\(cygwin\).*/cygwin/')
41 
42 export	HOSTARCH HOSTOS
43 
44 # Deal with colliding definitions from tcsh etc.
45 VENDOR=
46 
47 #########################################################################
48 #
49 # U-boot build supports producing a object files to the separate external
50 # directory. Two use cases are supported:
51 #
52 # 1) Add O= to the make command line
53 # 'make O=/tmp/build all'
54 #
55 # 2) Set environement variable BUILD_DIR to point to the desired location
56 # 'export BUILD_DIR=/tmp/build'
57 # 'make'
58 #
59 # The second approach can also be used with a MAKEALL script
60 # 'export BUILD_DIR=/tmp/build'
61 # './MAKEALL'
62 #
63 # Command line 'O=' setting overrides BUILD_DIR environent variable.
64 #
65 # When none of the above methods is used the local build is performed and
66 # the object files are placed in the source directory.
67 #
68 
69 ifdef O
70 ifeq ("$(origin O)", "command line")
71 BUILD_DIR := $(O)
72 endif
73 endif
74 
75 ifneq ($(BUILD_DIR),)
76 saved-output := $(BUILD_DIR)
77 
78 # Attempt to create a output directory.
79 $(shell [ -d ${BUILD_DIR} ] || mkdir -p ${BUILD_DIR})
80 
81 # Verify if it was successful.
82 BUILD_DIR := $(shell cd $(BUILD_DIR) && /bin/pwd)
83 $(if $(BUILD_DIR),,$(error output directory "$(saved-output)" does not exist))
84 endif # ifneq ($(BUILD_DIR),)
85 
86 OBJTREE		:= $(if $(BUILD_DIR),$(BUILD_DIR),$(CURDIR))
87 SRCTREE		:= $(CURDIR)
88 TOPDIR		:= $(SRCTREE)
89 LNDIR		:= $(OBJTREE)
90 export	TOPDIR SRCTREE OBJTREE
91 
92 MKCONFIG	:= $(SRCTREE)/mkconfig
93 export MKCONFIG
94 
95 ifneq ($(OBJTREE),$(SRCTREE))
96 REMOTE_BUILD 	:= 1
97 export REMOTE_BUILD
98 endif
99 
100 # $(obj) and (src) are defined in config.mk but here in main Makefile
101 # we also need them before config.mk is included which is the case for
102 # some targets like unconfig, clean, clobber, distclean, etc.
103 ifneq ($(OBJTREE),$(SRCTREE))
104 obj := $(OBJTREE)/
105 src := $(SRCTREE)/
106 else
107 obj :=
108 src :=
109 endif
110 export obj src
111 
112 #########################################################################
113 
114 ifeq ($(OBJTREE)/include/config.mk,$(wildcard $(OBJTREE)/include/config.mk))
115 
116 # load ARCH, BOARD, and CPU configuration
117 include $(OBJTREE)/include/config.mk
118 export	ARCH CPU BOARD VENDOR SOC
119 
120 ifndef CROSS_COMPILE
121 ifeq ($(HOSTARCH),ppc)
122 CROSS_COMPILE =
123 else
124 ifeq ($(ARCH),ppc)
125 CROSS_COMPILE = powerpc-linux-
126 endif
127 ifeq ($(ARCH),arm)
128 CROSS_COMPILE = arm-linux-
129 endif
130 ifeq ($(ARCH),i386)
131 ifeq ($(HOSTARCH),i386)
132 CROSS_COMPILE =
133 else
134 CROSS_COMPILE = i386-linux-
135 endif
136 endif
137 ifeq ($(ARCH),mips)
138 CROSS_COMPILE = mips_4KC-
139 endif
140 ifeq ($(ARCH),nios)
141 CROSS_COMPILE = nios-elf-
142 endif
143 ifeq ($(ARCH),nios2)
144 CROSS_COMPILE = nios2-elf-
145 endif
146 ifeq ($(ARCH),m68k)
147 CROSS_COMPILE = m68k-elf-
148 endif
149 ifeq ($(ARCH),microblaze)
150 CROSS_COMPILE = mb-
151 endif
152 ifeq ($(ARCH),blackfin)
153 CROSS_COMPILE = bfin-elf-
154 endif
155 ifeq ($(ARCH),avr32)
156 CROSS_COMPILE = avr32-
157 endif
158 endif
159 endif
160 
161 export	CROSS_COMPILE
162 
163 # load other configuration
164 include $(TOPDIR)/config.mk
165 
166 #########################################################################
167 # U-Boot objects....order is important (i.e. start must be first)
168 
169 OBJS  = cpu/$(CPU)/start.o
170 ifeq ($(CPU),i386)
171 OBJS += cpu/$(CPU)/start16.o
172 OBJS += cpu/$(CPU)/reset.o
173 endif
174 ifeq ($(CPU),ppc4xx)
175 OBJS += cpu/$(CPU)/resetvec.o
176 endif
177 ifeq ($(CPU),mpc83xx)
178 OBJS += cpu/$(CPU)/resetvec.o
179 endif
180 ifeq ($(CPU),mpc85xx)
181 OBJS += cpu/$(CPU)/resetvec.o
182 endif
183 ifeq ($(CPU),mpc86xx)
184 OBJS += cpu/$(CPU)/resetvec.o
185 endif
186 ifeq ($(CPU),bf533)
187 OBJS += cpu/$(CPU)/start1.o	cpu/$(CPU)/interrupt.o	cpu/$(CPU)/cache.o
188 OBJS += cpu/$(CPU)/cplbhdlr.o	cpu/$(CPU)/cplbmgr.o	cpu/$(CPU)/flush.o
189 endif
190 
191 OBJS := $(addprefix $(obj),$(OBJS))
192 
193 LIBS  = lib_generic/libgeneric.a
194 LIBS += board/$(BOARDDIR)/lib$(BOARD).a
195 LIBS += cpu/$(CPU)/lib$(CPU).a
196 ifdef SOC
197 LIBS += cpu/$(CPU)/$(SOC)/lib$(SOC).a
198 endif
199 LIBS += lib_$(ARCH)/lib$(ARCH).a
200 LIBS += fs/cramfs/libcramfs.a fs/fat/libfat.a fs/fdos/libfdos.a fs/jffs2/libjffs2.a \
201 	fs/reiserfs/libreiserfs.a fs/ext2/libext2fs.a
202 LIBS += net/libnet.a
203 LIBS += disk/libdisk.a
204 LIBS += rtc/librtc.a
205 LIBS += dtt/libdtt.a
206 LIBS += drivers/libdrivers.a
207 LIBS += drivers/nand/libnand.a
208 LIBS += drivers/nand_legacy/libnand_legacy.a
209 LIBS += drivers/sk98lin/libsk98lin.a
210 LIBS += post/libpost.a post/cpu/libcpu.a
211 LIBS += common/libcommon.a
212 LIBS += $(BOARDLIBS)
213 
214 LIBS := $(addprefix $(obj),$(LIBS))
215 .PHONY : $(LIBS)
216 
217 # Add GCC lib
218 PLATFORM_LIBS += -L $(shell dirname `$(CC) $(CFLAGS) -print-libgcc-file-name`) -lgcc
219 
220 # The "tools" are needed early, so put this first
221 # Don't include stuff already done in $(LIBS)
222 SUBDIRS	= tools \
223 	  examples \
224 	  post \
225 	  post/cpu
226 .PHONY : $(SUBDIRS)
227 
228 ifeq ($(CONFIG_NAND_U_BOOT),y)
229 NAND_SPL = nand_spl
230 U_BOOT_NAND = $(obj)u-boot-nand.bin
231 endif
232 
233 __OBJS := $(subst $(obj),,$(OBJS))
234 __LIBS := $(subst $(obj),,$(LIBS))
235 
236 #########################################################################
237 #########################################################################
238 
239 ALL = $(obj)u-boot.srec $(obj)u-boot.bin $(obj)System.map $(U_BOOT_NAND)
240 
241 all:		$(ALL)
242 
243 $(obj)u-boot.hex:	$(obj)u-boot
244 		$(OBJCOPY) ${OBJCFLAGS} -O ihex $< $@
245 
246 $(obj)u-boot.srec:	$(obj)u-boot
247 		$(OBJCOPY) ${OBJCFLAGS} -O srec $< $@
248 
249 $(obj)u-boot.bin:	$(obj)u-boot
250 		$(OBJCOPY) ${OBJCFLAGS} -O binary $< $@
251 
252 $(obj)u-boot.img:	$(obj)u-boot.bin
253 		./tools/mkimage -A $(ARCH) -T firmware -C none \
254 		-a $(TEXT_BASE) -e 0 \
255 		-n $(shell sed -n -e 's/.*U_BOOT_VERSION//p' $(VERSION_FILE) | \
256 			sed -e 's/"[	 ]*$$/ for $(BOARD) board"/') \
257 		-d $< $@
258 
259 $(obj)u-boot.dis:	$(obj)u-boot
260 		$(OBJDUMP) -d $< > $@
261 
262 $(obj)u-boot:		depend version $(SUBDIRS) $(OBJS) $(LIBS) $(LDSCRIPT)
263 		UNDEF_SYM=`$(OBJDUMP) -x $(LIBS) |sed  -n -e 's/.*\(__u_boot_cmd_.*\)/-u\1/p'|sort|uniq`;\
264 		cd $(LNDIR) && $(LD) $(LDFLAGS) $$UNDEF_SYM $(__OBJS) \
265 			--start-group $(__LIBS) --end-group $(PLATFORM_LIBS) \
266 			-Map u-boot.map -o u-boot
267 
268 $(OBJS):
269 		$(MAKE) -C cpu/$(CPU) $(if $(REMOTE_BUILD),$@,$(notdir $@))
270 
271 $(LIBS):
272 		$(MAKE) -C $(dir $(subst $(obj),,$@))
273 
274 $(SUBDIRS):
275 		$(MAKE) -C $@ all
276 
277 $(NAND_SPL):	version
278 		$(MAKE) -C nand_spl/board/$(BOARDDIR) all
279 
280 $(U_BOOT_NAND):	$(NAND_SPL) $(obj)u-boot.bin
281 		cat $(obj)nand_spl/u-boot-spl-16k.bin $(obj)u-boot.bin > $(obj)u-boot-nand.bin
282 
283 version:
284 		@echo -n "#define U_BOOT_VERSION \"U-Boot " > $(VERSION_FILE); \
285 		echo -n "$(U_BOOT_VERSION)" >> $(VERSION_FILE); \
286 		echo -n $(shell $(CONFIG_SHELL) $(TOPDIR)/tools/setlocalversion \
287 			 $(TOPDIR)) >> $(VERSION_FILE); \
288 		echo "\"" >> $(VERSION_FILE)
289 
290 gdbtools:
291 		$(MAKE) -C tools/gdb all || exit 1
292 
293 updater:
294 		$(MAKE) -C tools/updater all || exit 1
295 
296 env:
297 		$(MAKE) -C tools/env all || exit 1
298 
299 depend dep:
300 		for dir in $(SUBDIRS) ; do $(MAKE) -C $$dir _depend ; done
301 
302 tags ctags:
303 		ctags -w -o $(OBJTREE)/ctags `find $(SUBDIRS) include \
304 				lib_generic board/$(BOARDDIR) cpu/$(CPU) lib_$(ARCH) \
305 				fs/cramfs fs/fat fs/fdos fs/jffs2 \
306 				net disk rtc dtt drivers drivers/sk98lin common \
307 			\( -name CVS -prune \) -o \( -name '*.[ch]' -print \)`
308 
309 etags:
310 		etags -a -o $(OBJTREE)/etags `find $(SUBDIRS) include \
311 				lib_generic board/$(BOARDDIR) cpu/$(CPU) lib_$(ARCH) \
312 				fs/cramfs fs/fat fs/fdos fs/jffs2 \
313 				net disk rtc dtt drivers drivers/sk98lin common \
314 			\( -name CVS -prune \) -o \( -name '*.[ch]' -print \)`
315 
316 $(obj)System.map:	$(obj)u-boot
317 		@$(NM) $< | \
318 		grep -v '\(compiled\)\|\(\.o$$\)\|\( [aUw] \)\|\(\.\.ng$$\)\|\(LASH[RL]DI\)' | \
319 		sort > $(obj)System.map
320 
321 #########################################################################
322 else
323 all $(obj)u-boot.hex $(obj)u-boot.srec $(obj)u-boot.bin \
324 $(obj)u-boot.img $(obj)u-boot.dis $(obj)u-boot \
325 $(SUBDIRS) version gdbtools updater env depend \
326 dep tags ctags etags $(obj)System.map:
327 	@echo "System not configured - see README" >&2
328 	@ exit 1
329 endif
330 
331 .PHONY : CHANGELOG
332 CHANGELOG:
333 	git log --no-merges U-Boot-1_1_5.. | \
334 	unexpand -a | sed -e 's/\s\s*$$//' > $@
335 
336 #########################################################################
337 
338 unconfig:
339 	@rm -f $(obj)include/config.h $(obj)include/config.mk \
340 		$(obj)board/*/config.tmp $(obj)board/*/*/config.tmp
341 
342 #========================================================================
343 # PowerPC
344 #========================================================================
345 
346 #########################################################################
347 ## MPC5xx Systems
348 #########################################################################
349 
350 canmb_config:	unconfig
351 	@$(MKCONFIG) -a canmb ppc mpc5xxx canmb
352 
353 cmi_mpc5xx_config:	unconfig
354 	@$(MKCONFIG) $(@:_config=) ppc mpc5xx cmi
355 
356 PATI_config:		unconfig
357 	@$(MKCONFIG) $(@:_config=) ppc mpc5xx pati mpl
358 
359 #########################################################################
360 ## MPC5xxx Systems
361 #########################################################################
362 
363 aev_config: unconfig
364 	@$(MKCONFIG) -a aev ppc mpc5xxx tqm5200
365 
366 BC3450_config:	unconfig
367 	@$(MKCONFIG) -a BC3450 ppc mpc5xxx bc3450
368 
369 cpci5200_config:  unconfig
370 	@$(MKCONFIG) -a cpci5200  ppc mpc5xxx cpci5200 esd
371 
372 hmi1001_config:         unconfig
373 	@$(MKCONFIG) hmi1001 ppc mpc5xxx hmi1001
374 
375 Lite5200_config				\
376 Lite5200_LOWBOOT_config			\
377 Lite5200_LOWBOOT08_config		\
378 icecube_5200_config			\
379 icecube_5200_LOWBOOT_config		\
380 icecube_5200_LOWBOOT08_config		\
381 icecube_5200_DDR_config 		\
382 icecube_5200_DDR_LOWBOOT_config 	\
383 icecube_5200_DDR_LOWBOOT08_config	\
384 icecube_5100_config:			unconfig
385 	@mkdir -p $(obj)include
386 	@mkdir -p $(obj)board/icecube
387 	@ >$(obj)include/config.h
388 	@[ -z "$(findstring LOWBOOT_,$@)" ] || \
389 		{ if [ "$(findstring DDR,$@)" ] ; \
390 			then echo "TEXT_BASE = 0xFF800000" >$(obj)board/icecube/config.tmp ; \
391 			else echo "TEXT_BASE = 0xFF000000" >$(obj)board/icecube/config.tmp ; \
392 		  fi ; \
393 		  echo "... with LOWBOOT configuration" ; \
394 		}
395 	@[ -z "$(findstring LOWBOOT08,$@)" ] || \
396 		{ echo "TEXT_BASE = 0xFF800000" >$(obj)board/icecube/config.tmp ; \
397 		  echo "... with 8 MB flash only" ; \
398 		  echo "... with LOWBOOT configuration" ; \
399 		}
400 	@[ -z "$(findstring DDR,$@)" ] || \
401 		{ echo "#define CONFIG_MPC5200_DDR"	>>$(obj)include/config.h ; \
402 		  echo "... DDR memory revision" ; \
403 		}
404 	@[ -z "$(findstring 5200,$@)" ] || \
405 		{ echo "#define CONFIG_MPC5200"		>>$(obj)include/config.h ; \
406 		  echo "... with MPC5200 processor" ; \
407 		}
408 	@[ -z "$(findstring 5100,$@)" ] || \
409 		{ echo "#define CONFIG_MGT5100"		>>$(obj)include/config.h ; \
410 		  echo "... with MGT5100 processor" ; \
411 		}
412 	@$(MKCONFIG) -a IceCube ppc mpc5xxx icecube
413 
414 v38b_config: unconfig
415 	@./mkconfig -a V38B ppc mpc5xxx v38b
416 
417 inka4x0_config:	unconfig
418 	@$(MKCONFIG) inka4x0 ppc mpc5xxx inka4x0
419 
420 lite5200b_config	\
421 lite5200b_LOWBOOT_config:	unconfig
422 	@mkdir -p $(obj)include
423 	@mkdir -p $(obj)board/icecube
424 	@ >$(obj)include/config.h
425 	@ echo "#define CONFIG_MPC5200_DDR"	>>$(obj)include/config.h
426 	@ echo "... DDR memory revision"
427 	@ echo "#define CONFIG_MPC5200"		>>$(obj)include/config.h
428 	@ echo "#define CONFIG_LITE5200B"	>>$(obj)include/config.h
429 	@[ -z "$(findstring LOWBOOT_,$@)" ] || \
430 		{ echo "TEXT_BASE = 0xFF000000" >$(obj)board/icecube/config.tmp ; \
431 		  echo "... with LOWBOOT configuration" ; \
432 		}
433 	@ echo "... with MPC5200B processor"
434 	@$(MKCONFIG) -a IceCube  ppc mpc5xxx icecube
435 
436 mcc200_config	\
437 mcc200_SDRAM_config	\
438 mcc200_highboot_config	\
439 mcc200_COM12_config	\
440 mcc200_COM12_SDRAM_config	\
441 mcc200_COM12_highboot_config	\
442 mcc200_COM12_highboot_SDRAM_config	\
443 mcc200_highboot_SDRAM_config	\
444 prs200_config	\
445 prs200_DDR_config	\
446 prs200_highboot_config	\
447 prs200_highboot_DDR_config:	unconfig
448 	@mkdir -p $(obj)include
449 	@mkdir -p $(obj)board/mcc200
450 	@ >$(obj)include/config.h
451 	@[ -n "$(findstring highboot,$@)" ] || \
452 		{ echo "... with lowboot configuration" ; \
453 		}
454 	@[ -z "$(findstring highboot,$@)" ] || \
455 		{ echo "TEXT_BASE = 0xFFF00000" >$(obj)board/mcc200/config.tmp ; \
456 		  echo "... with highboot configuration" ; \
457 		}
458 	@[ -n "$(findstring _SDRAM,$@)" ] || \
459 		{ if [ -n "$(findstring mcc200,$@)" ]; \
460 		  then \
461 		  	echo "... with DDR" ; \
462 		  else \
463 			if [ -n "$(findstring _DDR,$@)" ];\
464 			then \
465 				echo "... with DDR" ; \
466 			else \
467 				echo "#define CONFIG_MCC200_SDRAM" >>$(obj)include/config.h ;\
468 				echo "... with SDRAM" ; \
469 			fi; \
470 		  fi; \
471 		}
472 	@[ -z "$(findstring _SDRAM,$@)" ] || \
473 		{ echo "#define CONFIG_MCC200_SDRAM"	>>$(obj)include/config.h ; \
474 		  echo "... with SDRAM" ; \
475 		}
476 	@[ -z "$(findstring COM12,$@)" ] || \
477 		{ echo "#define CONFIG_CONSOLE_COM12"	>>$(obj)include/config.h ; \
478 		  echo "... with console on COM12" ; \
479 		}
480 	@[ -z "$(findstring prs200,$@)" ] || \
481 		{ echo "#define CONFIG_PRS200"  >>$(obj)include/config.h ;\
482 		}
483 	@$(MKCONFIG) -n $@ -a mcc200 ppc mpc5xxx mcc200
484 
485 o2dnt_config:
486 	@$(MKCONFIG) o2dnt ppc mpc5xxx o2dnt
487 
488 pf5200_config:  unconfig
489 	@$(MKCONFIG) pf5200  ppc mpc5xxx pf5200 esd
490 
491 PM520_config \
492 PM520_DDR_config \
493 PM520_ROMBOOT_config \
494 PM520_ROMBOOT_DDR_config:	unconfig
495 	@mkdir -p $(obj)include
496 	@ >$(obj)include/config.h
497 	@[ -z "$(findstring DDR,$@)" ] || \
498 		{ echo "#define CONFIG_MPC5200_DDR"	>>$(obj)include/config.h ; \
499 		  echo "... DDR memory revision" ; \
500 		}
501 	@[ -z "$(findstring ROMBOOT,$@)" ] || \
502 		{ echo "#define CONFIG_BOOT_ROM" >>$(obj)include/config.h ; \
503 		  echo "... booting from 8-bit flash" ; \
504 		}
505 	@$(MKCONFIG) -a PM520 ppc mpc5xxx pm520
506 
507 smmaco4_config: unconfig
508 	@$(MKCONFIG) -a smmaco4 ppc mpc5xxx tqm5200
509 
510 spieval_config:	unconfig
511 	@$(MKCONFIG) -a spieval ppc mpc5xxx tqm5200
512 
513 TB5200_B_config \
514 TB5200_config:	unconfig
515 	@mkdir -p $(obj)include
516 	@[ -z "$(findstring _B,$@)" ] || \
517 		{ echo "#define CONFIG_TQM5200_B"	>>$(obj)include/config.h ; \
518 		  echo "... with MPC5200B processor" ; \
519 		}
520 	@$(MKCONFIG) -n $@ -a TB5200 ppc mpc5xxx tqm5200
521 
522 MINI5200_config	\
523 EVAL5200_config	\
524 TOP5200_config:	unconfig
525 	@mkdir -p $(obj)include
526 	@ echo "#define CONFIG_$(@:_config=) 1"	>$(obj)include/config.h
527 	@$(MKCONFIG) -n $@ -a TOP5200 ppc mpc5xxx top5200 emk
528 
529 Total5100_config		\
530 Total5200_config		\
531 Total5200_lowboot_config	\
532 Total5200_Rev2_config		\
533 Total5200_Rev2_lowboot_config:	unconfig
534 	@mkdir -p $(obj)include
535 	@mkdir -p $(obj)board/total5200
536 	@ >$(obj)include/config.h
537 	@[ -z "$(findstring 5100,$@)" ] || \
538 		{ echo "#define CONFIG_MGT5100"		>>$(obj)include/config.h ; \
539 		  echo "... with MGT5100 processor" ; \
540 		}
541 	@[ -z "$(findstring 5200,$@)" ] || \
542 		{ echo "#define CONFIG_MPC5200"		>>$(obj)include/config.h ; \
543 		  echo "... with MPC5200 processor" ; \
544 		}
545 	@[ -n "$(findstring Rev,$@)" ] || \
546 		{ echo "#define CONFIG_TOTAL5200_REV 1"	>>$(obj)include/config.h ; \
547 		  echo "... revision 1 board" ; \
548 		}
549 	@[ -z "$(findstring Rev2_,$@)" ] || \
550 		{ echo "#define CONFIG_TOTAL5200_REV 2"	>>$(obj)include/config.h ; \
551 		  echo "... revision 2 board" ; \
552 		}
553 	@[ -z "$(findstring lowboot_,$@)" ] || \
554 		{ echo "TEXT_BASE = 0xFE000000" >$(obj)board/total5200/config.tmp ; \
555 		  echo "... with lowboot configuration" ; \
556 		}
557 	@$(MKCONFIG) -a Total5200 ppc mpc5xxx total5200
558 
559 cam5200_config \
560 fo300_config \
561 MiniFAP_config \
562 TQM5200S_config \
563 TQM5200S_HIGHBOOT_config \
564 TQM5200_B_config \
565 TQM5200_B_HIGHBOOT_config \
566 TQM5200_config	\
567 TQM5200_STK100_config:	unconfig
568 	@mkdir -p $(obj)include
569 	@mkdir -p $(obj)board/tqm5200
570 	@ >$(obj)include/config.h
571 	@[ -z "$(findstring cam5200,$@)" ] || \
572 		{ echo "#define CONFIG_CAM5200"	>>$(obj)include/config.h ; \
573 		  echo "#define CONFIG_TQM5200S"	>>$(obj)include/config.h ; \
574 		  echo "#define CONFIG_TQM5200_B"	>>$(obj)include/config.h ; \
575 		  echo "... TQM5200S on Cam5200" ; \
576 		}
577 	@[ -z "$(findstring fo300,$@)" ] || \
578 		{ echo "#define CONFIG_FO300"	>>$(obj)include/config.h ; \
579 		  echo "... TQM5200 on FO300" ; \
580 		}
581 	@[ -z "$(findstring MiniFAP,$@)" ] || \
582 		{ echo "#define CONFIG_MINIFAP"	>>$(obj)include/config.h ; \
583 		  echo "... TQM5200_AC on MiniFAP" ; \
584 		}
585 	@[ -z "$(findstring STK100,$@)" ] || \
586 		{ echo "#define CONFIG_STK52XX_REV100"	>>$(obj)include/config.h ; \
587 		  echo "... on a STK52XX.100 base board" ; \
588 		}
589 	@[ -z "$(findstring TQM5200_B,$@)" ] || \
590 		{ echo "#define CONFIG_TQM5200_B"	>>$(obj)include/config.h ; \
591 		}
592 	@[ -z "$(findstring TQM5200S,$@)" ] || \
593 		{ echo "#define CONFIG_TQM5200S"	>>$(obj)include/config.h ; \
594 		  echo "#define CONFIG_TQM5200_B"	>>$(obj)include/config.h ; \
595 		}
596 	@[ -z "$(findstring HIGHBOOT,$@)" ] || \
597 		{ echo "TEXT_BASE = 0xFFF00000" >$(obj)board/tqm5200/config.tmp ; \
598 		}
599 	@$(MKCONFIG) -n $@ -a TQM5200 ppc mpc5xxx tqm5200
600 
601 #########################################################################
602 ## MPC8xx Systems
603 #########################################################################
604 
605 Adder_config    \
606 Adder87x_config \
607 AdderII_config  \
608 	:		unconfig
609 	@mkdir -p $(obj)include
610 	$(if $(findstring AdderII,$@), \
611 	@echo "#define CONFIG_MPC852T" > $(obj)include/config.h)
612 	@$(MKCONFIG) -a Adder ppc mpc8xx adder
613 
614 ADS860_config     \
615 FADS823_config    \
616 FADS850SAR_config \
617 MPC86xADS_config  \
618 MPC885ADS_config  \
619 FADS860T_config:	unconfig
620 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx fads
621 
622 AMX860_config	:	unconfig
623 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx amx860 westel
624 
625 c2mon_config:		unconfig
626 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx c2mon
627 
628 CCM_config:		unconfig
629 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx CCM siemens
630 
631 cogent_mpc8xx_config:	unconfig
632 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx cogent
633 
634 ELPT860_config:		unconfig
635 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx elpt860 LEOX
636 
637 EP88x_config:		unconfig
638 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx ep88x
639 
640 ESTEEM192E_config:	unconfig
641 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx esteem192e
642 
643 ETX094_config	:	unconfig
644 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx etx094
645 
646 FLAGADM_config:	unconfig
647 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx flagadm
648 
649 xtract_GEN860T = $(subst _SC,,$(subst _config,,$1))
650 
651 GEN860T_SC_config	\
652 GEN860T_config: unconfig
653 	@mkdir -p $(obj)include
654 	@ >$(obj)include/config.h
655 	@[ -z "$(findstring _SC,$@)" ] || \
656 		{ echo "#define CONFIG_SC" >>$(obj)include/config.h ; \
657 		  echo "With reduced H/W feature set (SC)..." ; \
658 		}
659 	@$(MKCONFIG) -a $(call xtract_GEN860T,$@) ppc mpc8xx gen860t
660 
661 GENIETV_config:	unconfig
662 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx genietv
663 
664 GTH_config:	unconfig
665 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx gth
666 
667 hermes_config	:	unconfig
668 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx hermes
669 
670 HMI10_config	:	unconfig
671 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx tqm8xx
672 
673 IAD210_config: unconfig
674 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx IAD210 siemens
675 
676 xtract_ICU862 = $(subst _100MHz,,$(subst _config,,$1))
677 
678 ICU862_100MHz_config	\
679 ICU862_config: unconfig
680 	@mkdir -p $(obj)include
681 	@ >$(obj)include/config.h
682 	@[ -z "$(findstring _100MHz,$@)" ] || \
683 		{ echo "#define CONFIG_100MHz"	>>$(obj)include/config.h ; \
684 		  echo "... with 100MHz system clock" ; \
685 		}
686 	@$(MKCONFIG) -a $(call xtract_ICU862,$@) ppc mpc8xx icu862
687 
688 IP860_config	:	unconfig
689 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx ip860
690 
691 IVML24_256_config \
692 IVML24_128_config \
693 IVML24_config:	unconfig
694 	@mkdir -p $(obj)include
695 	@ >$(obj)include/config.h
696 	@[ -z "$(findstring IVML24_config,$@)" ] || \
697 		 { echo "#define CONFIG_IVML24_16M"	>>$(obj)include/config.h ; \
698 		 }
699 	@[ -z "$(findstring IVML24_128_config,$@)" ] || \
700 		 { echo "#define CONFIG_IVML24_32M"	>>$(obj)include/config.h ; \
701 		 }
702 	@[ -z "$(findstring IVML24_256_config,$@)" ] || \
703 		 { echo "#define CONFIG_IVML24_64M"	>>$(obj)include/config.h ; \
704 		 }
705 	@$(MKCONFIG) -a IVML24 ppc mpc8xx ivm
706 
707 IVMS8_256_config \
708 IVMS8_128_config \
709 IVMS8_config:	unconfig
710 	@mkdir -p $(obj)include
711 	@ >$(obj)include/config.h
712 	@[ -z "$(findstring IVMS8_config,$@)" ] || \
713 		 { echo "#define CONFIG_IVMS8_16M"	>>$(obj)include/config.h ; \
714 		 }
715 	@[ -z "$(findstring IVMS8_128_config,$@)" ] || \
716 		 { echo "#define CONFIG_IVMS8_32M"	>>$(obj)include/config.h ; \
717 		 }
718 	@[ -z "$(findstring IVMS8_256_config,$@)" ] || \
719 		 { echo "#define CONFIG_IVMS8_64M"	>>$(obj)include/config.h ; \
720 		 }
721 	@$(MKCONFIG) -a IVMS8 ppc mpc8xx ivm
722 
723 KUP4K_config	:	unconfig
724 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx kup4k kup
725 
726 KUP4X_config    :       unconfig
727 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx kup4x kup
728 
729 LANTEC_config	:	unconfig
730 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx lantec
731 
732 lwmon_config:		unconfig
733 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx lwmon
734 
735 MBX_config	\
736 MBX860T_config:	unconfig
737 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx mbx8xx
738 
739 MHPC_config:		unconfig
740 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx mhpc eltec
741 
742 MVS1_config :		unconfig
743 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx mvs1
744 
745 xtract_NETVIA = $(subst _V2,,$(subst _config,,$1))
746 
747 NETVIA_V2_config \
748 NETVIA_config:		unconfig
749 	@mkdir -p $(obj)include
750 	@ >$(obj)include/config.h
751 	@[ -z "$(findstring NETVIA_config,$@)" ] || \
752 		 { echo "#define CONFIG_NETVIA_VERSION 1" >>$(obj)include/config.h ; \
753 		  echo "... Version 1" ; \
754 		 }
755 	@[ -z "$(findstring NETVIA_V2_config,$@)" ] || \
756 		 { echo "#define CONFIG_NETVIA_VERSION 2" >>$(obj)include/config.h ; \
757 		  echo "... Version 2" ; \
758 		 }
759 	@$(MKCONFIG) -a $(call xtract_NETVIA,$@) ppc mpc8xx netvia
760 
761 xtract_NETPHONE = $(subst _V2,,$(subst _config,,$1))
762 
763 NETPHONE_V2_config \
764 NETPHONE_config:	unconfig
765 	@mkdir -p $(obj)include
766 	@ >$(obj)include/config.h
767 	@[ -z "$(findstring NETPHONE_config,$@)" ] || \
768 		 { echo "#define CONFIG_NETPHONE_VERSION 1" >>$(obj)include/config.h ; \
769 		 }
770 	@[ -z "$(findstring NETPHONE_V2_config,$@)" ] || \
771 		 { echo "#define CONFIG_NETPHONE_VERSION 2" >>$(obj)include/config.h ; \
772 		 }
773 	@$(MKCONFIG) -a $(call xtract_NETPHONE,$@) ppc mpc8xx netphone
774 
775 xtract_NETTA = $(subst _SWAPHOOK,,$(subst _6412,,$(subst _ISDN,,$(subst _config,,$1))))
776 
777 NETTA_ISDN_6412_SWAPHOOK_config \
778 NETTA_ISDN_SWAPHOOK_config \
779 NETTA_6412_SWAPHOOK_config \
780 NETTA_SWAPHOOK_config \
781 NETTA_ISDN_6412_config \
782 NETTA_ISDN_config \
783 NETTA_6412_config \
784 NETTA_config:		unconfig
785 	@mkdir -p $(obj)include
786 	@ >$(obj)include/config.h
787 	@[ -z "$(findstring ISDN_,$@)" ] || \
788 		 { echo "#define CONFIG_NETTA_ISDN 1" >>$(obj)include/config.h ; \
789 		 }
790 	@[ -n "$(findstring ISDN_,$@)" ] || \
791 		 { echo "#undef CONFIG_NETTA_ISDN" >>$(obj)include/config.h ; \
792 		 }
793 	@[ -z "$(findstring 6412_,$@)" ] || \
794 		 { echo "#define CONFIG_NETTA_6412 1" >>$(obj)include/config.h ; \
795 		 }
796 	@[ -n "$(findstring 6412_,$@)" ] || \
797 		 { echo "#undef CONFIG_NETTA_6412" >>$(obj)include/config.h ; \
798 		 }
799 	@[ -z "$(findstring SWAPHOOK_,$@)" ] || \
800 		 { echo "#define CONFIG_NETTA_SWAPHOOK 1" >>$(obj)include/config.h ; \
801 		 }
802 	@[ -n "$(findstring SWAPHOOK_,$@)" ] || \
803 		 { echo "#undef CONFIG_NETTA_SWAPHOOK" >>$(obj)include/config.h ; \
804 		 }
805 	@$(MKCONFIG) -a $(call xtract_NETTA,$@) ppc mpc8xx netta
806 
807 xtract_NETTA2 = $(subst _V2,,$(subst _config,,$1))
808 
809 NETTA2_V2_config \
810 NETTA2_config:		unconfig
811 	@mkdir -p $(obj)include
812 	@ >$(obj)include/config.h
813 	@[ -z "$(findstring NETTA2_config,$@)" ] || \
814 		 { echo "#define CONFIG_NETTA2_VERSION 1" >>$(obj)include/config.h ; \
815 		 }
816 	@[ -z "$(findstring NETTA2_V2_config,$@)" ] || \
817 		 { echo "#define CONFIG_NETTA2_VERSION 2" >>$(obj)include/config.h ; \
818 		 }
819 	@$(MKCONFIG) -a $(call xtract_NETTA2,$@) ppc mpc8xx netta2
820 
821 NC650_Rev1_config \
822 NC650_Rev2_config \
823 CP850_config:	unconfig
824 	@mkdir -p $(obj)include
825 	@ >$(obj)include/config.h
826 	@[ -z "$(findstring CP850,$@)" ] || \
827 		 { echo "#define CONFIG_CP850 1" >>$(obj)include/config.h ; \
828 		   echo "#define CONFIG_IDS852_REV2 1" >>$(obj)include/config.h ; \
829 		 }
830 	@[ -z "$(findstring Rev1,$@)" ] || \
831 		 { echo "#define CONFIG_IDS852_REV1 1" >>$(obj)include/config.h ; \
832 		 }
833 	@[ -z "$(findstring Rev2,$@)" ] || \
834 		 { echo "#define CONFIG_IDS852_REV2 1" >>$(obj)include/config.h ; \
835 		 }
836 	@$(MKCONFIG) -a NC650 ppc mpc8xx nc650
837 
838 NX823_config:		unconfig
839 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx nx823
840 
841 pcu_e_config:		unconfig
842 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx pcu_e siemens
843 
844 QS850_config:	unconfig
845 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx qs850 snmc
846 
847 QS823_config:	unconfig
848 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx qs850 snmc
849 
850 QS860T_config:	unconfig
851 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx qs860t snmc
852 
853 quantum_config:	unconfig
854 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx quantum
855 
856 R360MPI_config:	unconfig
857 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx r360mpi
858 
859 RBC823_config:	unconfig
860 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx rbc823
861 
862 RPXClassic_config:	unconfig
863 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx RPXClassic
864 
865 RPXlite_config:		unconfig
866 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx RPXlite
867 
868 RPXlite_DW_64_config  		\
869 RPXlite_DW_LCD_config 		\
870 RPXlite_DW_64_LCD_config 	\
871 RPXlite_DW_NVRAM_config		\
872 RPXlite_DW_NVRAM_64_config      \
873 RPXlite_DW_NVRAM_LCD_config	\
874 RPXlite_DW_NVRAM_64_LCD_config  \
875 RPXlite_DW_config:         unconfig
876 	@mkdir -p $(obj)include
877 	@ >$(obj)include/config.h
878 	@[ -z "$(findstring _64,$@)" ] || \
879 		{ echo "#define RPXlite_64MHz"		>>$(obj)include/config.h ; \
880 		  echo "... with 64MHz system clock ..."; \
881 		}
882 	@[ -z "$(findstring _LCD,$@)" ] || \
883 		{ echo "#define CONFIG_LCD"          	>>$(obj)include/config.h ; \
884 		  echo "#define CONFIG_NEC_NL6448BC20"	>>$(obj)include/config.h ; \
885 		  echo "... with LCD display ..."; \
886 		}
887 	@[ -z "$(findstring _NVRAM,$@)" ] || \
888 		{ echo "#define  CFG_ENV_IS_IN_NVRAM" 	>>$(obj)include/config.h ; \
889 		  echo "... with ENV in NVRAM ..."; \
890 		}
891 	@$(MKCONFIG) -a RPXlite_DW ppc mpc8xx RPXlite_dw
892 
893 rmu_config:	unconfig
894 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx rmu
895 
896 RRvision_config:	unconfig
897 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx RRvision
898 
899 RRvision_LCD_config:	unconfig
900 	@mkdir -p $(obj)include
901 	@echo "#define CONFIG_LCD" >$(obj)include/config.h
902 	@echo "#define CONFIG_SHARP_LQ104V7DS01" >>$(obj)include/config.h
903 	@$(MKCONFIG) -a RRvision ppc mpc8xx RRvision
904 
905 SM850_config	:	unconfig
906 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx tqm8xx
907 
908 spc1920_config:
909 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx spc1920
910 
911 SPD823TS_config:	unconfig
912 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx spd8xx
913 
914 stxxtc_config:	unconfig
915 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx stxxtc
916 
917 svm_sc8xx_config:	unconfig
918 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx svm_sc8xx
919 
920 SXNI855T_config:	unconfig
921 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx sixnet
922 
923 # EMK MPC8xx based modules
924 TOP860_config:		unconfig
925 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx top860 emk
926 
927 # Play some tricks for configuration selection
928 # Only 855 and 860 boards may come with FEC
929 # and only 823 boards may have LCD support
930 xtract_8xx = $(subst _LCD,,$(subst _config,,$1))
931 
932 FPS850L_config		\
933 FPS860L_config		\
934 NSCU_config		\
935 TQM823L_config		\
936 TQM823L_LCD_config	\
937 TQM850L_config		\
938 TQM855L_config		\
939 TQM860L_config		\
940 TQM862L_config		\
941 TQM823M_config		\
942 TQM850M_config		\
943 TQM855M_config		\
944 TQM860M_config		\
945 TQM862M_config		\
946 TQM866M_config		\
947 TQM885D_config		\
948 virtlab2_config:	unconfig
949 	@mkdir -p $(obj)include
950 	@ >$(obj)include/config.h
951 	@[ -z "$(findstring _LCD,$@)" ] || \
952 		{ echo "#define CONFIG_LCD"		>>$(obj)include/config.h ; \
953 		  echo "#define CONFIG_NEC_NL6448BC20"	>>$(obj)include/config.h ; \
954 		  echo "... with LCD display" ; \
955 		}
956 	@$(MKCONFIG) -a $(call xtract_8xx,$@) ppc mpc8xx tqm8xx
957 
958 TTTech_config:	unconfig
959 	@mkdir -p $(obj)include
960 	@echo "#define CONFIG_LCD" >$(obj)include/config.h
961 	@echo "#define CONFIG_SHARP_LQ104V7DS01" >>$(obj)include/config.h
962 	@$(MKCONFIG) -a TQM823L ppc mpc8xx tqm8xx
963 
964 uc100_config	:	unconfig
965 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx uc100
966 
967 v37_config:	unconfig
968 	@mkdir -p $(obj)include
969 	@echo "#define CONFIG_LCD" >$(obj)include/config.h
970 	@echo "#define CONFIG_SHARP_LQ084V1DG21" >>$(obj)include/config.h
971 	@$(MKCONFIG) $(@:_config=) ppc mpc8xx v37
972 
973 wtk_config:	unconfig
974 	@mkdir -p $(obj)include
975 	@echo "#define CONFIG_LCD" >$(obj)include/config.h
976 	@echo "#define CONFIG_SHARP_LQ065T9DR51U" >>$(obj)include/config.h
977 	@$(MKCONFIG) -a TQM823L ppc mpc8xx tqm8xx
978 
979 #########################################################################
980 ## PPC4xx Systems
981 #########################################################################
982 xtract_4xx = $(subst _25,,$(subst _33,,$(subst _BA,,$(subst _ME,,$(subst _HI,,$(subst _config,,$1))))))
983 
984 ADCIOP_config:	unconfig
985 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx adciop esd
986 
987 AP1000_config:unconfig
988 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ap1000 amirix
989 
990 APC405_config:	unconfig
991 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx apc405 esd
992 
993 AR405_config:	unconfig
994 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ar405 esd
995 
996 ASH405_config:	unconfig
997 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ash405 esd
998 
999 bamboo_config:	unconfig
1000 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx bamboo amcc
1001 
1002 bubinga_config:	unconfig
1003 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx bubinga amcc
1004 
1005 CANBT_config:	unconfig
1006 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx canbt esd
1007 
1008 CATcenter_config	\
1009 CATcenter_25_config	\
1010 CATcenter_33_config:	unconfig
1011 	@mkdir -p $(obj)include
1012 	@ echo "/* CATcenter uses PPChameleon Model ME */"  > $(obj)include/config.h
1013 	@ echo "#define CONFIG_PPCHAMELEON_MODULE_MODEL 1" >> $(obj)include/config.h
1014 	@[ -z "$(findstring _25,$@)" ] || \
1015 		{ echo "#define CONFIG_PPCHAMELEON_CLK_25" >> $(obj)include/config.h ; \
1016 		  echo "SysClk = 25MHz" ; \
1017 		}
1018 	@[ -z "$(findstring _33,$@)" ] || \
1019 		{ echo "#define CONFIG_PPCHAMELEON_CLK_33" >> $(obj)include/config.h ; \
1020 		  echo "SysClk = 33MHz" ; \
1021 		}
1022 	@$(MKCONFIG) -a $(call xtract_4xx,$@) ppc ppc4xx PPChameleonEVB dave
1023 
1024 CPCI2DP_config:	unconfig
1025 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx cpci2dp esd
1026 
1027 CPCI405_config	\
1028 CPCI4052_config	\
1029 CPCI405DT_config	\
1030 CPCI405AB_config:	unconfig
1031 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx cpci405 esd
1032 	@echo "BOARD_REVISION = $(@:_config=)"	>> $(obj)include/config.mk
1033 
1034 CPCI440_config:	unconfig
1035 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx cpci440 esd
1036 
1037 CPCIISER4_config:	unconfig
1038 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx cpciiser4 esd
1039 
1040 CRAYL1_config:	unconfig
1041 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx L1 cray
1042 
1043 csb272_config:	unconfig
1044 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx csb272
1045 
1046 csb472_config:	unconfig
1047 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx csb472
1048 
1049 DASA_SIM_config: unconfig
1050 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx dasa_sim esd
1051 
1052 DP405_config:	unconfig
1053 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx dp405 esd
1054 
1055 DU405_config:	unconfig
1056 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx du405 esd
1057 
1058 ebony_config:	unconfig
1059 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ebony amcc
1060 
1061 ERIC_config:	unconfig
1062 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx eric
1063 
1064 EXBITGEN_config:	unconfig
1065 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx exbitgen
1066 
1067 G2000_config:	unconfig
1068 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx g2000
1069 
1070 HH405_config:	unconfig
1071 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx hh405 esd
1072 
1073 HUB405_config:	unconfig
1074 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx hub405 esd
1075 
1076 JSE_config:	unconfig
1077 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx jse
1078 
1079 KAREF_config: unconfig
1080 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx karef sandburst
1081 
1082 luan_config:	unconfig
1083 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx luan amcc
1084 
1085 METROBOX_config: unconfig
1086 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx metrobox sandburst
1087 
1088 MIP405_config:	unconfig
1089 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx mip405 mpl
1090 
1091 MIP405T_config:	unconfig
1092 	@mkdir -p $(obj)include
1093 	@echo "#define CONFIG_MIP405T" >$(obj)include/config.h
1094 	@echo "Enable subset config for MIP405T"
1095 	@$(MKCONFIG) -a MIP405 ppc ppc4xx mip405 mpl
1096 
1097 ML2_config:	unconfig
1098 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ml2
1099 
1100 ml300_config:	unconfig
1101 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ml300 xilinx
1102 
1103 ocotea_config:	unconfig
1104 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ocotea amcc
1105 
1106 OCRTC_config		\
1107 ORSG_config:	unconfig
1108 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx ocrtc esd
1109 
1110 p3p440_config:	unconfig
1111 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx p3p440 prodrive
1112 
1113 PCI405_config:	unconfig
1114 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx pci405 esd
1115 
1116 pcs440ep_config:	unconfig
1117 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx pcs440ep
1118 
1119 PIP405_config:	unconfig
1120 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx pip405 mpl
1121 
1122 PLU405_config:	unconfig
1123 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx plu405 esd
1124 
1125 PMC405_config:	unconfig
1126 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx pmc405 esd
1127 
1128 PPChameleonEVB_config		\
1129 PPChameleonEVB_BA_25_config	\
1130 PPChameleonEVB_ME_25_config	\
1131 PPChameleonEVB_HI_25_config	\
1132 PPChameleonEVB_BA_33_config	\
1133 PPChameleonEVB_ME_33_config	\
1134 PPChameleonEVB_HI_33_config:	unconfig
1135 	@mkdir -p $(obj)include
1136 	@ >$(obj)include/config.h
1137 	@[ -z "$(findstring EVB_BA,$@)" ] || \
1138 		{ echo "#define CONFIG_PPCHAMELEON_MODULE_MODEL 0" >>$(obj)include/config.h ; \
1139 		  echo "... BASIC model" ; \
1140 		}
1141 	@[ -z "$(findstring EVB_ME,$@)" ] || \
1142 		{ echo "#define CONFIG_PPCHAMELEON_MODULE_MODEL 1" >>$(obj)include/config.h ; \
1143 		  echo "... MEDIUM model" ; \
1144 		}
1145 	@[ -z "$(findstring EVB_HI,$@)" ] || \
1146 		{ echo "#define CONFIG_PPCHAMELEON_MODULE_MODEL 2" >>$(obj)include/config.h ; \
1147 		  echo "... HIGH-END model" ; \
1148 		}
1149 	@[ -z "$(findstring _25,$@)" ] || \
1150 		{ echo "#define CONFIG_PPCHAMELEON_CLK_25" >>$(obj)include/config.h ; \
1151 		  echo "SysClk = 25MHz" ; \
1152 		}
1153 	@[ -z "$(findstring _33,$@)" ] || \
1154 		{ echo "#define CONFIG_PPCHAMELEON_CLK_33" >>$(obj)include/config.h ; \
1155 		  echo "SysClk = 33MHz" ; \
1156 		}
1157 	@$(MKCONFIG) -a $(call xtract_4xx,$@) ppc ppc4xx PPChameleonEVB dave
1158 
1159 rainier_config:	unconfig
1160 	@mkdir -p $(obj)include
1161 	@echo "#define CONFIG_RAINIER" > $(obj)include/config.h
1162 	@echo "Configuring for rainier board as subset of sequoia..."
1163 	@$(MKCONFIG) -a sequoia ppc ppc4xx sequoia amcc
1164 
1165 rainier_nand_config:	unconfig
1166 	@mkdir -p $(obj)include
1167 	@mkdir -p $(obj)nand_spl
1168 	@mkdir -p $(obj)board/amcc/sequoia
1169 	@echo "#define CONFIG_RAINIER" > $(obj)include/config.h
1170 	@echo "Configuring for rainier board as subset of sequoia..."
1171 	@echo "#define CONFIG_NAND_U_BOOT" >> $(obj)include/config.h
1172 	@echo "Compile NAND boot image for sequoia"
1173 	@$(MKCONFIG) -a sequoia ppc ppc4xx sequoia amcc
1174 	@echo "TEXT_BASE = 0x01000000" > $(obj)board/amcc/sequoia/config.tmp
1175 	@echo "CONFIG_NAND_U_BOOT = y" >> $(obj)include/config.mk
1176 
1177 sbc405_config:	unconfig
1178 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx sbc405
1179 
1180 sequoia_config:	unconfig
1181 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx sequoia amcc
1182 
1183 sequoia_nand_config:	unconfig
1184 	@mkdir -p $(obj)include
1185 	@mkdir -p $(obj)nand_spl
1186 	@mkdir -p $(obj)board/amcc/sequoia
1187 	@echo "#define CONFIG_NAND_U_BOOT" > $(obj)include/config.h
1188 	@echo "Compile NAND boot image for sequoia"
1189 	@$(MKCONFIG) -a sequoia ppc ppc4xx sequoia amcc
1190 	@echo "TEXT_BASE = 0x01000000" > $(obj)board/amcc/sequoia/config.tmp
1191 	@echo "CONFIG_NAND_U_BOOT = y" >> $(obj)include/config.mk
1192 
1193 sycamore_config:	unconfig
1194 	@echo "Configuring for sycamore board as subset of walnut..."
1195 	@$(MKCONFIG) -a walnut ppc ppc4xx walnut amcc
1196 
1197 VOH405_config:	unconfig
1198 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx voh405 esd
1199 
1200 VOM405_config:	unconfig
1201 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx vom405 esd
1202 
1203 CMS700_config:	unconfig
1204 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx cms700 esd
1205 
1206 W7OLMC_config	\
1207 W7OLMG_config: unconfig
1208 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx w7o
1209 
1210 walnut_config: unconfig
1211 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx walnut amcc
1212 
1213 WUH405_config:	unconfig
1214 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx wuh405 esd
1215 
1216 XPEDITE1K_config:	unconfig
1217 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx xpedite1k
1218 
1219 yosemite_config:	unconfig
1220 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx yosemite amcc
1221 
1222 yellowstone_config:	unconfig
1223 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx yellowstone amcc
1224 
1225 yucca_config:	unconfig
1226 	@$(MKCONFIG) $(@:_config=) ppc ppc4xx yucca amcc
1227 
1228 #########################################################################
1229 ## MPC8220 Systems
1230 #########################################################################
1231 
1232 Alaska8220_config	\
1233 Yukon8220_config:	unconfig
1234 	@$(MKCONFIG) $(@:_config=) ppc mpc8220 alaska
1235 
1236 sorcery_config:		unconfig
1237 	@$(MKCONFIG) $(@:_config=) ppc mpc8220 sorcery
1238 
1239 #########################################################################
1240 ## MPC824x Systems
1241 #########################################################################
1242 xtract_82xx = $(subst _BIGFLASH,,$(subst _ROMBOOT,,$(subst _L2,,$(subst _266MHz,,$(subst _300MHz,,$(subst _config,,$1))))))
1243 
1244 A3000_config: unconfig
1245 	@$(MKCONFIG) $(@:_config=) ppc mpc824x a3000
1246 
1247 barco_config: unconfig
1248 	@$(MKCONFIG) $(@:_config=) ppc mpc824x barco
1249 
1250 BMW_config: unconfig
1251 	@$(MKCONFIG) $(@:_config=) ppc mpc824x bmw
1252 
1253 CPC45_config	\
1254 CPC45_ROMBOOT_config:	unconfig
1255 	@$(MKCONFIG) $(call xtract_82xx,$@) ppc mpc824x cpc45
1256 	@cd $(obj)include ;				\
1257 	if [ "$(findstring _ROMBOOT_,$@)" ] ; then \
1258 		echo "CONFIG_BOOT_ROM = y" >> config.mk ; \
1259 		echo "... booting from 8-bit flash" ; \
1260 	else \
1261 		echo "CONFIG_BOOT_ROM = n" >> config.mk ; \
1262 		echo "... booting from 64-bit flash" ; \
1263 	fi; \
1264 	echo "export CONFIG_BOOT_ROM" >> config.mk;
1265 
1266 CU824_config: unconfig
1267 	@$(MKCONFIG) $(@:_config=) ppc mpc824x cu824
1268 
1269 debris_config: unconfig
1270 	@$(MKCONFIG) $(@:_config=) ppc mpc824x debris etin
1271 
1272 eXalion_config: unconfig
1273 	@$(MKCONFIG) $(@:_config=) ppc mpc824x eXalion
1274 
1275 HIDDEN_DRAGON_config: unconfig
1276 	@$(MKCONFIG) $(@:_config=) ppc mpc824x hidden_dragon
1277 
1278 kvme080_config: unconfig
1279 	@$(MKCONFIG) $(@:_config=) ppc mpc824x kvme080 etin
1280 
1281 MOUSSE_config: unconfig
1282 	@$(MKCONFIG) $(@:_config=) ppc mpc824x mousse
1283 
1284 MUSENKI_config: unconfig
1285 	@$(MKCONFIG) $(@:_config=) ppc mpc824x musenki
1286 
1287 MVBLUE_config:	unconfig
1288 	@$(MKCONFIG) $(@:_config=) ppc mpc824x mvblue
1289 
1290 OXC_config: unconfig
1291 	@$(MKCONFIG) $(@:_config=) ppc mpc824x oxc
1292 
1293 PN62_config: unconfig
1294 	@$(MKCONFIG) $(@:_config=) ppc mpc824x pn62
1295 
1296 Sandpoint8240_config: unconfig
1297 	@$(MKCONFIG) $(@:_config=) ppc mpc824x sandpoint
1298 
1299 Sandpoint8245_config: unconfig
1300 	@$(MKCONFIG) $(@:_config=) ppc mpc824x sandpoint
1301 
1302 sbc8240_config: unconfig
1303 	@$(MKCONFIG) $(@:_config=) ppc mpc824x sbc8240
1304 
1305 SL8245_config: unconfig
1306 	@$(MKCONFIG) $(@:_config=) ppc mpc824x sl8245
1307 
1308 utx8245_config: unconfig
1309 	@$(MKCONFIG) $(@:_config=) ppc mpc824x utx8245
1310 
1311 #########################################################################
1312 ## MPC8260 Systems
1313 #########################################################################
1314 
1315 atc_config:	unconfig
1316 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 atc
1317 
1318 cogent_mpc8260_config:	unconfig
1319 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 cogent
1320 
1321 CPU86_config	\
1322 CPU86_ROMBOOT_config: unconfig
1323 	@$(MKCONFIG) $(call xtract_82xx,$@) ppc mpc8260 cpu86
1324 	@cd $(obj)include ;				\
1325 	if [ "$(findstring _ROMBOOT_,$@)" ] ; then \
1326 		echo "CONFIG_BOOT_ROM = y" >> config.mk ; \
1327 		echo "... booting from 8-bit flash" ; \
1328 	else \
1329 		echo "CONFIG_BOOT_ROM = n" >> config.mk ; \
1330 		echo "... booting from 64-bit flash" ; \
1331 	fi; \
1332 	echo "export CONFIG_BOOT_ROM" >> config.mk;
1333 
1334 CPU87_config	\
1335 CPU87_ROMBOOT_config: unconfig
1336 	@$(MKCONFIG) $(call xtract_82xx,$@) ppc mpc8260 cpu87
1337 	@cd $(obj)include ;				\
1338 	if [ "$(findstring _ROMBOOT_,$@)" ] ; then \
1339 		echo "CONFIG_BOOT_ROM = y" >> config.mk ; \
1340 		echo "... booting from 8-bit flash" ; \
1341 	else \
1342 		echo "CONFIG_BOOT_ROM = n" >> config.mk ; \
1343 		echo "... booting from 64-bit flash" ; \
1344 	fi; \
1345 	echo "export CONFIG_BOOT_ROM" >> config.mk;
1346 
1347 ep8248_config	\
1348 ep8248E_config	:	unconfig
1349 	@$(MKCONFIG) ep8248 ppc mpc8260 ep8248
1350 
1351 ep8260_config:	unconfig
1352 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 ep8260
1353 
1354 ep82xxm_config:	unconfig
1355 	@./mkconfig $(@:_config=) ppc mpc8260 ep82xxm
1356 
1357 gw8260_config:	unconfig
1358 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 gw8260
1359 
1360 hymod_config:	unconfig
1361 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 hymod
1362 
1363 IDS8247_config:	unconfig
1364 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 ids8247
1365 
1366 IPHASE4539_config:	unconfig
1367 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 iphase4539
1368 
1369 ISPAN_config		\
1370 ISPAN_REVB_config:	unconfig
1371 	@mkdir -p $(obj)include
1372 	@if [ "$(findstring _REVB_,$@)" ] ; then \
1373 		echo "#define CFG_REV_B" > $(obj)include/config.h ; \
1374 	fi
1375 	@$(MKCONFIG) -a ISPAN ppc mpc8260 ispan
1376 
1377 MPC8260ADS_config	\
1378 MPC8260ADS_lowboot_config	\
1379 MPC8260ADS_33MHz_config	\
1380 MPC8260ADS_33MHz_lowboot_config	\
1381 MPC8260ADS_40MHz_config	\
1382 MPC8260ADS_40MHz_lowboot_config	\
1383 MPC8272ADS_config	\
1384 MPC8272ADS_lowboot_config	\
1385 PQ2FADS_config		\
1386 PQ2FADS_lowboot_config		\
1387 PQ2FADS-VR_config	\
1388 PQ2FADS-VR_lowboot_config	\
1389 PQ2FADS-ZU_config	\
1390 PQ2FADS-ZU_lowboot_config	\
1391 PQ2FADS-ZU_66MHz_config	\
1392 PQ2FADS-ZU_66MHz_lowboot_config	\
1393 	:		unconfig
1394 	@mkdir -p $(obj)include
1395 	@mkdir -p $(obj)board/mpc8260ads
1396 	$(if $(findstring PQ2FADS,$@), \
1397 	@echo "#define CONFIG_ADSTYPE CFG_PQ2FADS" > $(obj)include/config.h, \
1398 	@echo "#define CONFIG_ADSTYPE CFG_"$(subst MPC,,$(word 1,$(subst _, ,$@))) > $(obj)include/config.h)
1399 	$(if $(findstring MHz,$@), \
1400 	@echo "#define CONFIG_8260_CLKIN" $(subst MHz,,$(word 2,$(subst _, ,$@)))"000000" >> $(obj)include/config.h, \
1401 	$(if $(findstring VR,$@), \
1402 	@echo "#define CONFIG_8260_CLKIN 66000000" >> $(obj)include/config.h))
1403 	@[ -z "$(findstring lowboot_,$@)" ] || \
1404 		{ echo "TEXT_BASE = 0xFF800000" >$(obj)board/mpc8260ads/config.tmp ; \
1405 		  echo "... with lowboot configuration" ; \
1406 		}
1407 	@$(MKCONFIG) -a MPC8260ADS ppc mpc8260 mpc8260ads
1408 
1409 MPC8266ADS_config:	unconfig
1410 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 mpc8266ads
1411 
1412 # PM825/PM826 default configuration:  small (= 8 MB) Flash / boot from 64-bit flash
1413 PM825_config	\
1414 PM825_ROMBOOT_config	\
1415 PM825_BIGFLASH_config	\
1416 PM825_ROMBOOT_BIGFLASH_config	\
1417 PM826_config	\
1418 PM826_ROMBOOT_config	\
1419 PM826_BIGFLASH_config	\
1420 PM826_ROMBOOT_BIGFLASH_config:	unconfig
1421 	@mkdir -p $(obj)include
1422 	@mkdir -p $(obj)board/pm826
1423 	@if [ "$(findstring PM825_,$@)" ] ; then \
1424 		echo "#define CONFIG_PCI"	>$(obj)include/config.h ; \
1425 	else \
1426 		>$(obj)include/config.h ; \
1427 	fi
1428 	@if [ "$(findstring _ROMBOOT_,$@)" ] ; then \
1429 		echo "... booting from 8-bit flash" ; \
1430 		echo "#define CONFIG_BOOT_ROM" >>$(obj)include/config.h ; \
1431 		echo "TEXT_BASE = 0xFF800000" >$(obj)board/pm826/config.tmp ; \
1432 		if [ "$(findstring _BIGFLASH_,$@)" ] ; then \
1433 			echo "... with 32 MB Flash" ; \
1434 			echo "#define CONFIG_FLASH_32MB" >>$(obj)include/config.h ; \
1435 		fi; \
1436 	else \
1437 		echo "... booting from 64-bit flash" ; \
1438 		if [ "$(findstring _BIGFLASH_,$@)" ] ; then \
1439 			echo "... with 32 MB Flash" ; \
1440 			echo "#define CONFIG_FLASH_32MB" >>$(obj)include/config.h ; \
1441 			echo "TEXT_BASE = 0x40000000" >$(obj)board/pm826/config.tmp ; \
1442 		else \
1443 			echo "TEXT_BASE = 0xFF000000" >$(obj)board/pm826/config.tmp ; \
1444 		fi; \
1445 	fi
1446 	@$(MKCONFIG) -a PM826 ppc mpc8260 pm826
1447 
1448 PM828_config	\
1449 PM828_PCI_config	\
1450 PM828_ROMBOOT_config	\
1451 PM828_ROMBOOT_PCI_config:	unconfig
1452 	@mkdir -p $(obj)include
1453 	@mkdir -p $(obj)board/pm826
1454 	@if [ "$(findstring _PCI_,$@)" ] ; then \
1455 		echo "#define CONFIG_PCI"  >>$(obj)include/config.h ; \
1456 		echo "... with PCI enabled" ; \
1457 	else \
1458 		>$(obj)include/config.h ; \
1459 	fi
1460 	@if [ "$(findstring _ROMBOOT_,$@)" ] ; then \
1461 		echo "... booting from 8-bit flash" ; \
1462 		echo "#define CONFIG_BOOT_ROM" >>$(obj)include/config.h ; \
1463 		echo "TEXT_BASE = 0xFF800000" >$(obj)board/pm826/config.tmp ; \
1464 	fi
1465 	@$(MKCONFIG) -a PM828 ppc mpc8260 pm828
1466 
1467 ppmc8260_config:	unconfig
1468 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 ppmc8260
1469 
1470 Rattler8248_config	\
1471 Rattler_config:		unconfig
1472 	@mkdir -p $(obj)include
1473 	$(if $(findstring 8248,$@), \
1474 	@echo "#define CONFIG_MPC8248" > $(obj)include/config.h)
1475 	@$(MKCONFIG) -a Rattler ppc mpc8260 rattler
1476 
1477 RPXsuper_config:	unconfig
1478 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 rpxsuper
1479 
1480 rsdproto_config:	unconfig
1481 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 rsdproto
1482 
1483 sacsng_config:	unconfig
1484 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 sacsng
1485 
1486 sbc8260_config:	unconfig
1487 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 sbc8260
1488 
1489 SCM_config:		unconfig
1490 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 SCM siemens
1491 
1492 TQM8255_AA_config \
1493 TQM8260_AA_config \
1494 TQM8260_AB_config \
1495 TQM8260_AC_config \
1496 TQM8260_AD_config \
1497 TQM8260_AE_config \
1498 TQM8260_AF_config \
1499 TQM8260_AG_config \
1500 TQM8260_AH_config \
1501 TQM8260_AI_config \
1502 TQM8265_AA_config:  unconfig
1503 	@mkdir -p $(obj)include
1504 	@case "$@" in \
1505 	TQM8255_AA_config) CTYPE=MPC8255; CFREQ=300; CACHE=no;	BMODE=8260;;  \
1506 	TQM8260_AA_config) CTYPE=MPC8260; CFREQ=200; CACHE=no;	BMODE=8260;; \
1507 	TQM8260_AB_config) CTYPE=MPC8260; CFREQ=200; CACHE=yes;	BMODE=60x;;  \
1508 	TQM8260_AC_config) CTYPE=MPC8260; CFREQ=200; CACHE=yes;	BMODE=60x;;  \
1509 	TQM8260_AD_config) CTYPE=MPC8260; CFREQ=300; CACHE=no;	BMODE=60x;;  \
1510 	TQM8260_AE_config) CTYPE=MPC8260; CFREQ=266; CACHE=no;	BMODE=8260;; \
1511 	TQM8260_AF_config) CTYPE=MPC8260; CFREQ=300; CACHE=no;	BMODE=60x;;  \
1512 	TQM8260_AG_config) CTYPE=MPC8260; CFREQ=300; CACHE=no;	BMODE=8260;; \
1513 	TQM8260_AH_config) CTYPE=MPC8260; CFREQ=300; CACHE=yes;	BMODE=60x;;  \
1514 	TQM8260_AI_config) CTYPE=MPC8260; CFREQ=300; CACHE=no;	BMODE=60x;;  \
1515 	TQM8265_AA_config) CTYPE=MPC8265; CFREQ=300; CACHE=no;	BMODE=60x;;  \
1516 	esac; \
1517 	>$(obj)include/config.h ; \
1518 	if [ "$${CTYPE}" != "MPC8260" ] ; then \
1519 		echo "#define CONFIG_$${CTYPE}"	>>$(obj)include/config.h ; \
1520 	fi; \
1521 	echo "#define CONFIG_$${CFREQ}MHz"	>>$(obj)include/config.h ; \
1522 	echo "... with $${CFREQ}MHz system clock" ; \
1523 	if [ "$${CACHE}" == "yes" ] ; then \
1524 		echo "#define CONFIG_L2_CACHE"	>>$(obj)include/config.h ; \
1525 		echo "... with L2 Cache support" ; \
1526 	else \
1527 		echo "#undef CONFIG_L2_CACHE"	>>$(obj)include/config.h ; \
1528 		echo "... without L2 Cache support" ; \
1529 	fi; \
1530 	if [ "$${BMODE}" == "60x" ] ; then \
1531 		echo "#define CONFIG_BUSMODE_60x" >>$(obj)include/config.h ; \
1532 		echo "... with 60x Bus Mode" ; \
1533 	else \
1534 		echo "#undef CONFIG_BUSMODE_60x"  >>$(obj)include/config.h ; \
1535 		echo "... without 60x Bus Mode" ; \
1536 	fi
1537 	@$(MKCONFIG) -a TQM8260 ppc mpc8260 tqm8260
1538 
1539 VoVPN-GW_66MHz_config	\
1540 VoVPN-GW_100MHz_config:		unconfig
1541 	@mkdir -p $(obj)include
1542 	@echo "#define CONFIG_CLKIN_$(word 2,$(subst _, ,$@))" > $(obj)include/config.h
1543 	@$(MKCONFIG) -a VoVPN-GW ppc mpc8260 vovpn-gw funkwerk
1544 
1545 ZPC1900_config: unconfig
1546 	@$(MKCONFIG) $(@:_config=) ppc mpc8260 zpc1900
1547 
1548 #########################################################################
1549 ## Coldfire
1550 #########################################################################
1551 
1552 cobra5272_config :		unconfig
1553 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 cobra5272
1554 
1555 EB+MCF-EV123_config :		unconfig
1556 	@mkdir -p $(obj)include
1557 	@mkdir -p $(obj)board/BuS/EB+MCF-EV123
1558 	@ >$(obj)include/config.h
1559 	@echo "TEXT_BASE = 0xFFE00000"|tee $(obj)board/BuS/EB+MCF-EV123/textbase.mk
1560 	@$(MKCONFIG) EB+MCF-EV123 m68k mcf52x2 EB+MCF-EV123 BuS
1561 
1562 EB+MCF-EV123_internal_config :	unconfig
1563 	@mkdir -p $(obj)include
1564 	@mkdir -p $(obj)board/BuS/EB+MCF-EV123
1565 	@ >$(obj)include/config.h
1566 	@echo "TEXT_BASE = 0xF0000000"|tee $(obj)board/BuS/EB+MCF-EV123/textbase.mk
1567 	@$(MKCONFIG) EB+MCF-EV123 m68k mcf52x2 EB+MCF-EV123 BuS
1568 
1569 M5271EVB_config :		unconfig
1570 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 m5271evb
1571 
1572 M5272C3_config :		unconfig
1573 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 m5272c3
1574 
1575 M5282EVB_config :		unconfig
1576 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 m5282evb
1577 
1578 TASREG_config :		unconfig
1579 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 tasreg esd
1580 
1581 r5200_config :		unconfig
1582 	@$(MKCONFIG) $(@:_config=) m68k mcf52x2 r5200
1583 
1584 #########################################################################
1585 ## MPC83xx Systems
1586 #########################################################################
1587 
1588 MPC8349ADS_config:	unconfig
1589 	@$(MKCONFIG) $(@:_config=) ppc mpc83xx mpc8349ads
1590 
1591 TQM834x_config:	unconfig
1592 	@$(MKCONFIG) $(@:_config=) ppc mpc83xx tqm834x
1593 
1594 MPC8349EMDS_config:	unconfig
1595 	@$(MKCONFIG) $(@:_config=) ppc mpc83xx mpc8349emds
1596 
1597 #########################################################################
1598 ## MPC85xx Systems
1599 #########################################################################
1600 
1601 MPC8540ADS_config:	unconfig
1602 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx mpc8540ads
1603 
1604 MPC8540EVAL_config \
1605 MPC8540EVAL_33_config \
1606 MPC8540EVAL_66_config \
1607 MPC8540EVAL_33_slave_config \
1608 MPC8540EVAL_66_slave_config:      unconfig
1609 	@mkdir -p $(obj)include
1610 	@echo "" >$(obj)include/config.h ; \
1611 	if [ "$(findstring _33_,$@)" ] ; then \
1612 		echo -n "... 33 MHz PCI" ; \
1613 	else \
1614 		echo "#define CONFIG_SYSCLK_66M" >>$(obj)include/config.h ; \
1615 		echo -n "... 66 MHz PCI" ; \
1616 	fi ; \
1617 	if [ "$(findstring _slave_,$@)" ] ; then \
1618 		echo "#define CONFIG_PCI_SLAVE" >>$(obj)include/config.h ; \
1619 		echo " slave" ; \
1620 	else \
1621 		echo " host" ; \
1622 	fi
1623 	@$(MKCONFIG) -a MPC8540EVAL ppc mpc85xx mpc8540eval
1624 
1625 MPC8560ADS_config:	unconfig
1626 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx mpc8560ads
1627 
1628 MPC8541CDS_config:	unconfig
1629 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx mpc8541cds cds
1630 
1631 MPC8548CDS_config:	unconfig
1632 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx mpc8548cds cds
1633 
1634 MPC8555CDS_config:	unconfig
1635 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx mpc8555cds cds
1636 
1637 PM854_config:	unconfig
1638 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx pm854
1639 
1640 PM856_config:	unconfig
1641 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx pm856
1642 
1643 sbc8540_config \
1644 sbc8540_33_config \
1645 sbc8540_66_config:	unconfig
1646 	@mkdir -p $(obj)include
1647 	@if [ "$(findstring _66_,$@)" ] ; then \
1648 		echo "#define CONFIG_PCI_66"	>>$(obj)include/config.h ; \
1649 		echo "... 66 MHz PCI" ; \
1650 	else \
1651 		>$(obj)include/config.h ; \
1652 		echo "... 33 MHz PCI" ; \
1653 	fi
1654 	@$(MKCONFIG) -a SBC8540 ppc mpc85xx sbc8560
1655 
1656 sbc8560_config \
1657 sbc8560_33_config \
1658 sbc8560_66_config:      unconfig
1659 	@mkdir -p $(obj)include
1660 	@if [ "$(findstring _66_,$@)" ] ; then \
1661 		echo "#define CONFIG_PCI_66"	>>$(obj)include/config.h ; \
1662 		echo "... 66 MHz PCI" ; \
1663 	else \
1664 		>$(obj)include/config.h ; \
1665 		echo "... 33 MHz PCI" ; \
1666 	fi
1667 	@$(MKCONFIG) -a sbc8560 ppc mpc85xx sbc8560
1668 
1669 stxgp3_config:		unconfig
1670 	@$(MKCONFIG) $(@:_config=) ppc mpc85xx stxgp3
1671 
1672 TQM8540_config		\
1673 TQM8541_config		\
1674 TQM8555_config		\
1675 TQM8560_config:		unconfig
1676 	@mkdir -p $(obj)include
1677 	@CTYPE=$(subst TQM,,$(@:_config=)); \
1678 	>$(obj)include/config.h ; \
1679 	echo "... TQM"$${CTYPE}; \
1680 	echo "#define CONFIG_MPC$${CTYPE}">>$(obj)include/config.h; \
1681 	echo "#define CONFIG_TQM$${CTYPE}">>$(obj)include/config.h; \
1682 	echo "#define CONFIG_HOSTNAME tqm$${CTYPE}">>$(obj)include/config.h; \
1683 	echo "#define CONFIG_BOARDNAME \"TQM$${CTYPE}\"">>$(obj)include/config.h; \
1684 	echo "#define CFG_BOOTFILE \"bootfile=/tftpboot/tqm$${CTYPE}/uImage\0\"">>$(obj)include/config.h
1685 	@$(MKCONFIG) -a TQM85xx ppc mpc85xx tqm85xx
1686 
1687 #########################################################################
1688 ## MPC86xx Systems
1689 #########################################################################
1690 
1691 MPC8641HPCN_config:    unconfig
1692 	@./mkconfig $(@:_config=) ppc mpc86xx mpc8641hpcn
1693 
1694 
1695 #########################################################################
1696 ## 74xx/7xx Systems
1697 #########################################################################
1698 
1699 AmigaOneG3SE_config:	unconfig
1700 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx AmigaOneG3SE MAI
1701 
1702 BAB7xx_config: unconfig
1703 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx bab7xx eltec
1704 
1705 CPCI750_config:        unconfig
1706 	@$(MKCONFIG) CPCI750 ppc 74xx_7xx cpci750 esd
1707 
1708 DB64360_config:  unconfig
1709 	@$(MKCONFIG) DB64360 ppc 74xx_7xx db64360 Marvell
1710 
1711 DB64460_config:  unconfig
1712 	@$(MKCONFIG) DB64460 ppc 74xx_7xx db64460 Marvell
1713 
1714 ELPPC_config: unconfig
1715 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx elppc eltec
1716 
1717 EVB64260_config	\
1718 EVB64260_750CX_config:	unconfig
1719 	@$(MKCONFIG) EVB64260 ppc 74xx_7xx evb64260
1720 
1721 P3G4_config: unconfig
1722 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx evb64260
1723 
1724 PCIPPC2_config \
1725 PCIPPC6_config: unconfig
1726 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx pcippc2
1727 
1728 ZUMA_config:	unconfig
1729 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx evb64260
1730 
1731 ppmc7xx_config: unconfig
1732 	@$(MKCONFIG) $(@:_config=) ppc 74xx_7xx ppmc7xx
1733 
1734 #========================================================================
1735 # ARM
1736 #========================================================================
1737 #########################################################################
1738 ## StrongARM Systems
1739 #########################################################################
1740 
1741 assabet_config	:	unconfig
1742 	@$(MKCONFIG) $(@:_config=) arm sa1100 assabet
1743 
1744 dnp1110_config	:	unconfig
1745 	@$(MKCONFIG) $(@:_config=) arm sa1100 dnp1110
1746 
1747 gcplus_config	:	unconfig
1748 	@$(MKCONFIG) $(@:_config=) arm sa1100 gcplus
1749 
1750 lart_config	:	unconfig
1751 	@$(MKCONFIG) $(@:_config=) arm sa1100 lart
1752 
1753 shannon_config	:	unconfig
1754 	@$(MKCONFIG) $(@:_config=) arm sa1100 shannon
1755 
1756 #########################################################################
1757 ## ARM92xT Systems
1758 #########################################################################
1759 
1760 xtract_trab = $(subst _bigram,,$(subst _bigflash,,$(subst _old,,$(subst _config,,$1))))
1761 
1762 xtract_omap1610xxx = $(subst _cs0boot,,$(subst _cs3boot,,$(subst _cs_autoboot,,$(subst _config,,$1))))
1763 
1764 xtract_omap730p2 = $(subst _cs0boot,,$(subst _cs3boot,, $(subst _config,,$1)))
1765 
1766 at91rm9200dk_config	:	unconfig
1767 	@$(MKCONFIG) $(@:_config=) arm arm920t at91rm9200dk NULL at91rm9200
1768 
1769 cmc_pu2_config	:	unconfig
1770 	@$(MKCONFIG) $(@:_config=) arm arm920t cmc_pu2 NULL at91rm9200
1771 
1772 csb637_config	:	unconfig
1773 	@$(MKCONFIG) $(@:_config=) arm arm920t csb637 NULL at91rm9200
1774 
1775 mp2usb_config	:	unconfig
1776 	@$(MKCONFIG) $(@:_config=) arm arm920t mp2usb NULL at91rm9200
1777 
1778 
1779 ########################################################################
1780 ## ARM Integrator boards - see doc/README-integrator for more info.
1781 integratorap_config	\
1782 ap_config		\
1783 ap966_config		\
1784 ap922_config		\
1785 ap922_XA10_config	\
1786 ap7_config		\
1787 ap720t_config  		\
1788 ap920t_config		\
1789 ap926ejs_config		\
1790 ap946es_config: unconfig
1791 	@board/integratorap/split_by_variant.sh $@
1792 
1793 integratorcp_config	\
1794 cp_config		\
1795 cp920t_config		\
1796 cp926ejs_config		\
1797 cp946es_config		\
1798 cp1136_config		\
1799 cp966_config		\
1800 cp922_config		\
1801 cp922_XA10_config	\
1802 cp1026_config: unconfig
1803 	@board/integratorcp/split_by_variant.sh $@
1804 
1805 kb9202_config	:	unconfig
1806 	@$(MKCONFIG) $(@:_config=) arm arm920t kb9202 NULL at91rm9200
1807 
1808 lpd7a400_config \
1809 lpd7a404_config:	unconfig
1810 	@$(MKCONFIG) $(@:_config=) arm lh7a40x lpd7a40x
1811 
1812 mx1ads_config	:	unconfig
1813 	@$(MKCONFIG) $(@:_config=) arm arm920t mx1ads NULL imx
1814 
1815 mx1fs2_config	:	unconfig
1816 	@$(MKCONFIG) $(@:_config=) arm arm920t mx1fs2 NULL imx
1817 
1818 netstar_32_config	\
1819 netstar_config:		unconfig
1820 	@mkdir -p $(obj)include
1821 	@if [ "$(findstring _32_,$@)" ] ; then \
1822 		echo "... 32MB SDRAM" ; \
1823 		echo "#define PHYS_SDRAM_1_SIZE SZ_32M" >>$(obj)include/config.h ; \
1824 	else \
1825 		echo "... 64MB SDRAM" ; \
1826 		echo "#define PHYS_SDRAM_1_SIZE SZ_64M" >>$(obj)include/config.h ; \
1827 	fi
1828 	@$(MKCONFIG) -a netstar arm arm925t netstar
1829 
1830 omap1510inn_config :	unconfig
1831 	@$(MKCONFIG) $(@:_config=) arm arm925t omap1510inn
1832 
1833 omap5912osk_config :	unconfig
1834 	@$(MKCONFIG) $(@:_config=) arm arm926ejs omap5912osk NULL omap
1835 
1836 omap1610inn_config \
1837 omap1610inn_cs0boot_config \
1838 omap1610inn_cs3boot_config \
1839 omap1610inn_cs_autoboot_config \
1840 omap1610h2_config \
1841 omap1610h2_cs0boot_config \
1842 omap1610h2_cs3boot_config \
1843 omap1610h2_cs_autoboot_config:	unconfig
1844 	@mkdir -p $(obj)include
1845 	@if [ "$(findstring _cs0boot_, $@)" ] ; then \
1846 		echo "#define CONFIG_CS0_BOOT" >> .$(obj)/include/config.h ; \
1847 		echo "... configured for CS0 boot"; \
1848 	elif [ "$(findstring _cs_autoboot_, $@)" ] ; then \
1849 		echo "#define CONFIG_CS_AUTOBOOT" >> $(obj)./include/config.h ; \
1850 		echo "... configured for CS_AUTO boot"; \
1851 	else \
1852 		echo "#define CONFIG_CS3_BOOT" >> $(obj)./include/config.h ; \
1853 		echo "... configured for CS3 boot"; \
1854 	fi;
1855 	@$(MKCONFIG) -a $(call xtract_omap1610xxx,$@) arm arm926ejs omap1610inn NULL omap
1856 
1857 omap730p2_config \
1858 omap730p2_cs0boot_config \
1859 omap730p2_cs3boot_config :	unconfig
1860 	@mkdir -p $(obj)include
1861 	@if [ "$(findstring _cs0boot_, $@)" ] ; then \
1862 		echo "#define CONFIG_CS0_BOOT" >> $(obj)include/config.h ; \
1863 		echo "... configured for CS0 boot"; \
1864 	else \
1865 		echo "#define CONFIG_CS3_BOOT" >> $(obj)include/config.h ; \
1866 		echo "... configured for CS3 boot"; \
1867 	fi;
1868 	@$(MKCONFIG) -a $(call xtract_omap730p2,$@) arm arm926ejs omap730p2 NULL omap
1869 
1870 sbc2410x_config: unconfig
1871 	@$(MKCONFIG) $(@:_config=) arm arm920t sbc2410x NULL s3c24x0
1872 
1873 scb9328_config	:	unconfig
1874 	@$(MKCONFIG) $(@:_config=) arm arm920t scb9328 NULL imx
1875 
1876 smdk2400_config	:	unconfig
1877 	@$(MKCONFIG) $(@:_config=) arm arm920t smdk2400 NULL s3c24x0
1878 
1879 smdk2410_config	:	unconfig
1880 	@$(MKCONFIG) $(@:_config=) arm arm920t smdk2410 NULL s3c24x0
1881 
1882 open24x0_config	:	unconfig
1883 	@$(MKCONFIG) $(@:_config=) arm arm920t open24x0 NULL s3c24x0
1884 
1885 SX1_config :		unconfig
1886 	@$(MKCONFIG) $(@:_config=) arm arm925t sx1
1887 
1888 # TRAB default configuration:	8 MB Flash, 32 MB RAM
1889 trab_config \
1890 trab_bigram_config \
1891 trab_bigflash_config \
1892 trab_old_config:	unconfig
1893 	@mkdir -p $(obj)include
1894 	@mkdir -p $(obj)board/trab
1895 	@ >$(obj)include/config.h
1896 	@[ -z "$(findstring _bigram,$@)" ] || \
1897 		{ echo "#define CONFIG_FLASH_8MB"  >>$(obj)include/config.h ; \
1898 		  echo "#define CONFIG_RAM_32MB"   >>$(obj)include/config.h ; \
1899 		  echo "... with 8 MB Flash, 32 MB RAM" ; \
1900 		}
1901 	@[ -z "$(findstring _bigflash,$@)" ] || \
1902 		{ echo "#define CONFIG_FLASH_16MB" >>$(obj)include/config.h ; \
1903 		  echo "#define CONFIG_RAM_16MB"   >>$(obj)include/config.h ; \
1904 		  echo "... with 16 MB Flash, 16 MB RAM" ; \
1905 		  echo "TEXT_BASE = 0x0CF40000" >$(obj)board/trab/config.tmp ; \
1906 		}
1907 	@[ -z "$(findstring _old,$@)" ] || \
1908 		{ echo "#define CONFIG_FLASH_8MB"  >>$(obj)include/config.h ; \
1909 		  echo "#define CONFIG_RAM_16MB"   >>$(obj)include/config.h ; \
1910 		  echo "... with 8 MB Flash, 16 MB RAM" ; \
1911 		  echo "TEXT_BASE = 0x0CF40000" >$(obj)board/trab/config.tmp ; \
1912 		}
1913 	@$(MKCONFIG) -a $(call xtract_trab,$@) arm arm920t trab NULL s3c24x0
1914 
1915 VCMA9_config	:	unconfig
1916 	@$(MKCONFIG) $(@:_config=) arm arm920t vcma9 mpl s3c24x0
1917 
1918 #========================================================================
1919 # ARM supplied Versatile development boards
1920 #========================================================================
1921 versatile_config	\
1922 versatileab_config	\
1923 versatilepb_config :	unconfig
1924 	@board/versatile/split_by_variant.sh $@
1925 
1926 voiceblue_smallflash_config	\
1927 voiceblue_config:	unconfig
1928 	@mkdir -p $(obj)include
1929 	@mkdir -p $(obj)board/voiceblue
1930 	@if [ "$(findstring _smallflash_,$@)" ] ; then \
1931 		echo "... boot from lower flash bank" ; \
1932 		echo "#define VOICEBLUE_SMALL_FLASH" >>$(obj)include/config.h ; \
1933 		echo "VOICEBLUE_SMALL_FLASH=y" >$(obj)board/voiceblue/config.tmp ; \
1934 	else \
1935 		echo "... boot from upper flash bank" ; \
1936 		>$(obj)include/config.h ; \
1937 		echo "VOICEBLUE_SMALL_FLASH=n" >$(obj)board/voiceblue/config.tmp ; \
1938 	fi
1939 	@$(MKCONFIG) -a voiceblue arm arm925t voiceblue
1940 
1941 cm4008_config	:	unconfig
1942 	@$(MKCONFIG) $(@:_config=) arm arm920t cm4008 NULL ks8695
1943 
1944 cm41xx_config	:	unconfig
1945 	@$(MKCONFIG) $(@:_config=) arm arm920t cm41xx NULL ks8695
1946 
1947 gth2_config		: 	unconfig
1948 	@mkdir -p $(obj)include
1949 	@ >$(obj)include/config.h
1950 	@echo "#define CONFIG_GTH2 1" >>$(obj)include/config.h
1951 	@$(MKCONFIG) -a gth2 mips mips gth2
1952 
1953 #########################################################################
1954 ## S3C44B0 Systems
1955 #########################################################################
1956 
1957 B2_config	:	unconfig
1958 	@$(MKCONFIG) $(@:_config=) arm s3c44b0 B2 dave
1959 
1960 #########################################################################
1961 ## ARM720T Systems
1962 #########################################################################
1963 
1964 armadillo_config:	unconfig
1965 	@$(MKCONFIG) $(@:_config=) arm arm720t armadillo
1966 
1967 ep7312_config	:	unconfig
1968 	@$(MKCONFIG) $(@:_config=) arm arm720t ep7312
1969 
1970 impa7_config	:	unconfig
1971 	@$(MKCONFIG) $(@:_config=) arm arm720t impa7
1972 
1973 modnet50_config :	unconfig
1974 	@$(MKCONFIG) $(@:_config=) arm arm720t modnet50
1975 
1976 evb4510_config :	unconfig
1977 	@$(MKCONFIG) $(@:_config=) arm arm720t evb4510
1978 
1979 #########################################################################
1980 ## XScale Systems
1981 #########################################################################
1982 
1983 adsvix_config	:	unconfig
1984 	@$(MKCONFIG) $(@:_config=) arm pxa adsvix
1985 
1986 cerf250_config :	unconfig
1987 	@$(MKCONFIG) $(@:_config=) arm pxa cerf250
1988 
1989 cradle_config	:	unconfig
1990 	@$(MKCONFIG) $(@:_config=) arm pxa cradle
1991 
1992 csb226_config	:	unconfig
1993 	@$(MKCONFIG) $(@:_config=) arm pxa csb226
1994 
1995 delta_config :
1996 	@$(MKCONFIG) $(@:_config=) arm pxa delta
1997 
1998 innokom_config	:	unconfig
1999 	@$(MKCONFIG) $(@:_config=) arm pxa innokom
2000 
2001 ixdp425_config	:	unconfig
2002 	@$(MKCONFIG) $(@:_config=) arm ixp ixdp425
2003 
2004 ixdpg425_config	:	unconfig
2005 	@$(MKCONFIG) $(@:_config=) arm ixp ixdp425
2006 
2007 lubbock_config	:	unconfig
2008 	@$(MKCONFIG) $(@:_config=) arm pxa lubbock
2009 
2010 pleb2_config	:	unconfig
2011 	@$(MKCONFIG) $(@:_config=) arm pxa pleb2
2012 
2013 logodl_config	:	unconfig
2014 	@$(MKCONFIG) $(@:_config=) arm pxa logodl
2015 
2016 pdnb3_config	:	unconfig
2017 	@$(MKCONFIG) $(@:_config=) arm ixp pdnb3 prodrive
2018 
2019 pxa255_idp_config:	unconfig
2020 	@$(MKCONFIG) $(@:_config=) arm pxa pxa255_idp
2021 
2022 wepep250_config	:	unconfig
2023 	@$(MKCONFIG) $(@:_config=) arm pxa wepep250
2024 
2025 xaeniax_config	:	unconfig
2026 	@$(MKCONFIG) $(@:_config=) arm pxa xaeniax
2027 
2028 xm250_config	:	unconfig
2029 	@$(MKCONFIG) $(@:_config=) arm pxa xm250
2030 
2031 xsengine_config :	unconfig
2032 	@$(MKCONFIG) $(@:_config=) arm pxa xsengine
2033 
2034 zylonite_config :
2035 	@$(MKCONFIG) $(@:_config=) arm pxa zylonite
2036 
2037 #########################################################################
2038 ## ARM1136 Systems
2039 #########################################################################
2040 omap2420h4_config :    unconfig
2041 	@$(MKCONFIG) $(@:_config=) arm arm1136 omap2420h4
2042 
2043 #========================================================================
2044 # i386
2045 #========================================================================
2046 #########################################################################
2047 ## AMD SC520 CDP
2048 #########################################################################
2049 sc520_cdp_config	:	unconfig
2050 	@$(MKCONFIG) $(@:_config=) i386 i386 sc520_cdp
2051 
2052 sc520_spunk_config	:	unconfig
2053 	@$(MKCONFIG) $(@:_config=) i386 i386 sc520_spunk
2054 
2055 sc520_spunk_rel_config	:	unconfig
2056 	@$(MKCONFIG) $(@:_config=) i386 i386 sc520_spunk
2057 
2058 #========================================================================
2059 # MIPS
2060 #========================================================================
2061 #########################################################################
2062 ## MIPS32 4Kc
2063 #########################################################################
2064 
2065 xtract_incaip = $(subst _100MHz,,$(subst _133MHz,,$(subst _150MHz,,$(subst _config,,$1))))
2066 
2067 incaip_100MHz_config	\
2068 incaip_133MHz_config	\
2069 incaip_150MHz_config	\
2070 incaip_config: unconfig
2071 	@mkdir -p $(obj)include
2072 	@ >$(obj)include/config.h
2073 	@[ -z "$(findstring _100MHz,$@)" ] || \
2074 		{ echo "#define CPU_CLOCK_RATE 100000000" >>$(obj)include/config.h ; \
2075 		  echo "... with 100MHz system clock" ; \
2076 		}
2077 	@[ -z "$(findstring _133MHz,$@)" ] || \
2078 		{ echo "#define CPU_CLOCK_RATE 133000000" >>$(obj)include/config.h ; \
2079 		  echo "... with 133MHz system clock" ; \
2080 		}
2081 	@[ -z "$(findstring _150MHz,$@)" ] || \
2082 		{ echo "#define CPU_CLOCK_RATE 150000000" >>$(obj)include/config.h ; \
2083 		  echo "... with 150MHz system clock" ; \
2084 		}
2085 	@$(MKCONFIG) -a $(call xtract_incaip,$@) mips mips incaip
2086 
2087 tb0229_config: unconfig
2088 	@$(MKCONFIG) $(@:_config=) mips mips tb0229
2089 
2090 #########################################################################
2091 ## MIPS32 AU1X00
2092 #########################################################################
2093 dbau1000_config		: 	unconfig
2094 	@mkdir -p $(obj)include
2095 	@ >$(obj)include/config.h
2096 	@echo "#define CONFIG_DBAU1000 1" >>$(obj)include/config.h
2097 	@$(MKCONFIG) -a dbau1x00 mips mips dbau1x00
2098 
2099 dbau1100_config		: 	unconfig
2100 	@mkdir -p $(obj)include
2101 	@ >$(obj)include/config.h
2102 	@echo "#define CONFIG_DBAU1100 1" >>$(obj)include/config.h
2103 	@$(MKCONFIG) -a dbau1x00 mips mips dbau1x00
2104 
2105 dbau1500_config		: 	unconfig
2106 	@mkdir -p $(obj)include
2107 	@ >$(obj)include/config.h
2108 	@echo "#define CONFIG_DBAU1500 1" >>$(obj)include/config.h
2109 	@$(MKCONFIG) -a dbau1x00 mips mips dbau1x00
2110 
2111 dbau1550_config		:	unconfig
2112 	@mkdir -p $(obj)include
2113 	@ >$(obj)include/config.h
2114 	@echo "#define CONFIG_DBAU1550 1" >>$(obj)include/config.h
2115 	@$(MKCONFIG) -a dbau1x00 mips mips dbau1x00
2116 
2117 dbau1550_el_config	:	unconfig
2118 	@mkdir -p $(obj)include
2119 	@ >$(obj)include/config.h
2120 	@echo "#define CONFIG_DBAU1550 1" >>$(obj)include/config.h
2121 	@$(MKCONFIG) -a dbau1x00 mips mips dbau1x00
2122 
2123 pb1000_config		: 	unconfig
2124 	@mkdir -p $(obj)include
2125 	@ >$(obj)include/config.h
2126 	@echo "#define CONFIG_PB1000 1" >>$(obj)include/config.h
2127 	@$(MKCONFIG) -a pb1x00 mips mips pb1x00
2128 
2129 #########################################################################
2130 ## MIPS64 5Kc
2131 #########################################################################
2132 
2133 purple_config :		unconfig
2134 	@$(MKCONFIG) $(@:_config=) mips mips purple
2135 
2136 #========================================================================
2137 # Nios
2138 #========================================================================
2139 #########################################################################
2140 ## Nios32
2141 #########################################################################
2142 
2143 DK1C20_safe_32_config		\
2144 DK1C20_standard_32_config	\
2145 DK1C20_config:	unconfig
2146 	@mkdir -p $(obj)include
2147 	@ >$(obj)include/config.h
2148 	@[ -z "$(findstring _safe_32,$@)" ] || \
2149 		{ echo "#define CONFIG_NIOS_SAFE_32 1" >>$(obj)include/config.h ; \
2150 		  echo "... NIOS 'safe_32' configuration" ; \
2151 		}
2152 	@[ -z "$(findstring _standard_32,$@)" ] || \
2153 		{ echo "#define CONFIG_NIOS_STANDARD_32 1" >>$(obj)include/config.h ; \
2154 		  echo "... NIOS 'standard_32' configuration" ; \
2155 		}
2156 	@[ -z "$(findstring DK1C20_config,$@)" ] || \
2157 		{ echo "#define CONFIG_NIOS_STANDARD_32 1" >>$(obj)include/config.h ; \
2158 		  echo "... NIOS 'standard_32' configuration (DEFAULT)" ; \
2159 		}
2160 	@$(MKCONFIG) -a DK1C20 nios nios dk1c20 altera
2161 
2162 DK1S10_safe_32_config		\
2163 DK1S10_standard_32_config	\
2164 DK1S10_mtx_ldk_20_config	\
2165 DK1S10_config:	unconfig
2166 	@mkdir -p $(obj)include
2167 	@ >$(obj)include/config.h
2168 	@[ -z "$(findstring _safe_32,$@)" ] || \
2169 		{ echo "#define CONFIG_NIOS_SAFE_32 1" >>$(obj)include/config.h ; \
2170 		  echo "... NIOS 'safe_32' configuration" ; \
2171 		}
2172 	@[ -z "$(findstring _standard_32,$@)" ] || \
2173 		{ echo "#define CONFIG_NIOS_STANDARD_32 1" >>$(obj)include/config.h ; \
2174 		  echo "... NIOS 'standard_32' configuration" ; \
2175 		}
2176 	@[ -z "$(findstring _mtx_ldk_20,$@)" ] || \
2177 		{ echo "#define CONFIG_NIOS_MTX_LDK_20 1" >>$(obj)include/config.h ; \
2178 		  echo "... NIOS 'mtx_ldk_20' configuration" ; \
2179 		}
2180 	@[ -z "$(findstring DK1S10_config,$@)" ] || \
2181 		{ echo "#define CONFIG_NIOS_STANDARD_32 1" >>$(obj)include/config.h ; \
2182 		  echo "... NIOS 'standard_32' configuration (DEFAULT)" ; \
2183 		}
2184 	@$(MKCONFIG) -a DK1S10 nios nios dk1s10 altera
2185 
2186 ADNPESC1_DNPEVA2_base_32_config	\
2187 ADNPESC1_base_32_config		\
2188 ADNPESC1_config: unconfig
2189 	@mkdir -p $(obj)include
2190 	@ >$(obj)include/config.h
2191 	@[ -z "$(findstring _DNPEVA2,$@)" ] || \
2192 		{ echo "#define CONFIG_DNPEVA2 1" >>$(obj)include/config.h ; \
2193 		  echo "... DNP/EVA2 configuration" ; \
2194 		}
2195 	@[ -z "$(findstring _base_32,$@)" ] || \
2196 		{ echo "#define CONFIG_NIOS_BASE_32 1" >>$(obj)include/config.h ; \
2197 		  echo "... NIOS 'base_32' configuration" ; \
2198 		}
2199 	@[ -z "$(findstring ADNPESC1_config,$@)" ] || \
2200 		{ echo "#define CONFIG_NIOS_BASE_32 1" >>$(obj)include/config.h ; \
2201 		  echo "... NIOS 'base_32' configuration (DEFAULT)" ; \
2202 		}
2203 	@$(MKCONFIG) -a ADNPESC1 nios nios adnpesc1 ssv
2204 
2205 #########################################################################
2206 ## Nios-II
2207 #########################################################################
2208 
2209 EP1C20_config : unconfig
2210 	@$(MKCONFIG)  EP1C20 nios2 nios2 ep1c20 altera
2211 
2212 EP1S10_config : unconfig
2213 	@$(MKCONFIG)  EP1S10 nios2 nios2 ep1s10 altera
2214 
2215 EP1S40_config : unconfig
2216 	@$(MKCONFIG)  EP1S40 nios2 nios2 ep1s40 altera
2217 
2218 PK1C20_config : unconfig
2219 	@$(MKCONFIG)  PK1C20 nios2 nios2 pk1c20 psyent
2220 
2221 PCI5441_config : unconfig
2222 	@$(MKCONFIG)  PCI5441 nios2 nios2 pci5441 psyent
2223 
2224 #========================================================================
2225 # MicroBlaze
2226 #========================================================================
2227 #########################################################################
2228 ## Microblaze
2229 #########################################################################
2230 suzaku_config:	unconfig
2231 	@mkdir -p $(obj)include
2232 	@ >$(obj)include/config.h
2233 	@echo "#define CONFIG_SUZAKU 1" >> $(obj)include/config.h
2234 	@$(MKCONFIG) -a $(@:_config=) microblaze microblaze suzaku AtmarkTechno
2235 
2236 #########################################################################
2237 ## Blackfin
2238 #########################################################################
2239 ezkit533_config	:	unconfig
2240 	@$(MKCONFIG) $(@:_config=) blackfin bf533 ezkit533
2241 
2242 stamp_config	:	unconfig
2243 	@$(MKCONFIG) $(@:_config=) blackfin bf533 stamp
2244 
2245 dspstamp_config	:	unconfig
2246 	@$(MKCONFIG) $(@:_config=) blackfin bf533 dsp_stamp
2247 
2248 #========================================================================
2249 # AVR32
2250 #========================================================================
2251 #########################################################################
2252 ## AT32AP7xxx
2253 #########################################################################
2254 
2255 atstk1002_config	:	unconfig
2256 	@./mkconfig $(@:_config=) avr32 at32ap atstk1000 atmel at32ap7000
2257 
2258 #########################################################################
2259 #########################################################################
2260 #########################################################################
2261 
2262 clean:
2263 	find $(OBJTREE) -type f \
2264 		\( -name 'core' -o -name '*.bak' -o -name '*~' \
2265 		-o -name '*.o'  -o -name '*.a'  \) -print \
2266 		| xargs rm -f
2267 	rm -f $(obj)examples/hello_world $(obj)examples/timer \
2268 	      $(obj)examples/eepro100_eeprom $(obj)examples/sched \
2269 	      $(obj)examples/mem_to_mem_idma2intr $(obj)examples/82559_eeprom \
2270 	      $(obj)examples/smc91111_eeprom $(obj)examples/interrupt \
2271 	      $(obj)examples/test_burst
2272 	rm -f $(obj)tools/img2srec $(obj)tools/mkimage $(obj)tools/envcrc \
2273 		$(obj)tools/gen_eth_addr
2274 	rm -f $(obj)tools/mpc86x_clk $(obj)tools/ncb
2275 	rm -f $(obj)tools/easylogo/easylogo $(obj)tools/bmp_logo
2276 	rm -f $(obj)tools/gdb/astest $(obj)tools/gdb/gdbcont $(obj)tools/gdb/gdbsend
2277 	rm -f $(obj)tools/env/fw_printenv $(obj)tools/env/fw_setenv
2278 	rm -f $(obj)board/cray/L1/bootscript.c $(obj)board/cray/L1/bootscript.image
2279 	rm -f $(obj)board/netstar/eeprom $(obj)board/netstar/crcek $(obj)board/netstar/crcit
2280 	rm -f $(obj)board/netstar/*.srec $(obj)board/netstar/*.bin
2281 	rm -f $(obj)board/trab/trab_fkt $(obj)board/voiceblue/eeprom
2282 	rm -f $(obj)board/integratorap/u-boot.lds $(obj)board/integratorcp/u-boot.lds
2283 	rm -f $(obj)include/bmp_logo.h
2284 	rm -f $(obj)nand_spl/u-boot-spl $(obj)nand_spl/u-boot-spl.map
2285 
2286 clobber:	clean
2287 	find $(OBJTREE) -type f \( -name .depend \
2288 		-o -name '*.srec' -o -name '*.bin' -o -name u-boot.img \) \
2289 		-print0 \
2290 		| xargs -0 rm -f
2291 	rm -f $(OBJS) $(obj)*.bak $(obj)ctags $(obj)etags $(obj)TAGS $(obj)include/version_autogenerated.h
2292 	rm -fr $(obj)*.*~
2293 	rm -f $(obj)u-boot $(obj)u-boot.map $(obj)u-boot.hex $(ALL)
2294 	rm -f $(obj)tools/crc32.c $(obj)tools/environment.c $(obj)tools/env/crc32.c
2295 	rm -f $(obj)tools/inca-swap-bytes $(obj)cpu/mpc824x/bedbug_603e.c
2296 	rm -f $(obj)include/asm/proc $(obj)include/asm/arch $(obj)include/asm
2297 	[ ! -d $(OBJTREE)/nand_spl ] || find $(obj)nand_spl -lname "*" -print | xargs rm -f
2298 
2299 ifeq ($(OBJTREE),$(SRCTREE))
2300 mrproper \
2301 distclean:	clobber unconfig
2302 else
2303 mrproper \
2304 distclean:	clobber unconfig
2305 	rm -rf $(OBJTREE)/*
2306 endif
2307 
2308 backup:
2309 	F=`basename $(TOPDIR)` ; cd .. ; \
2310 	gtar --force-local -zcvf `date "+$$F-%Y-%m-%d-%T.tar.gz"` $$F
2311 
2312 #########################################################################
