#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/miscdevice.h>
#include <linux/delay.h>
#include <asm/irq.h>
#include <asm/arch/regs-gpio.h>
#include <asm/hardware.h>

#define DEVICE_NAME	"backlight"
#define LED_MAJOR 235

static int micro2440_backlight_ioctl(
	struct inode *inode, 
	struct file *file, 
	unsigned int cmd, 
	unsigned long arg)
{
	switch(cmd) {
	case 0:
		s3c2410_gpio_setpin(S3C2410_GPG4, 0);
		return 0;
	case 1:
		s3c2410_gpio_setpin(S3C2410_GPG4, 1);
		return 0;
	default:
		return -EINVAL;
	}
}

static struct file_operations micro2440_backlight_fops = {
	.owner	=	THIS_MODULE,
	.ioctl	=	micro2440_backlight_ioctl,
};

static int __init micro2440_backlight_init(void)
{
	int ret;

	ret = register_chrdev(LED_MAJOR, DEVICE_NAME, &micro2440_backlight_fops);
	if (ret < 0) {
	  printk(DEVICE_NAME " can't register major number\n");
	  return ret;
	}

	devfs_mk_cdev(MKDEV(LED_MAJOR, 0), S_IFCHR | S_IRUSR | S_IWUSR | S_IRGRP, DEVICE_NAME);
	
	s3c2410_gpio_cfgpin(S3C2410_GPG4, S3C2410_GPG4_OUTP);
	s3c2410_gpio_setpin(S3C2410_GPG4, 1);

	printk(DEVICE_NAME " initialized\n");
	return 0;
}

static void __exit micro2440_backlight_exit(void)
{
	devfs_remove(DEVICE_NAME);
	unregister_chrdev(LED_MAJOR, DEVICE_NAME);
}

module_init(micro2440_backlight_init);
module_exit(micro2440_backlight_exit);
