// Demo Kṕ͈F Si4431, Si4432, Si4431PA
// RF W[p[^ݒF FSKC  433.92MHzC 1.2KBPSC +/-10PPM, g΍F30KHzC ϒшF61.2KHz 
//			AFCCCRCLɂC PH + FIFO [h
// bɑM̓ẽeXgMF 0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x6d, 
//                              0x6d = (0x41 +0x42 +0x43 +0x44 +0x45 +0x46 +0x47 + 0x48 +0x49)
// MCU : Microchip high performance 8 bit MCU :PIC16F689

#include<pic.h>
#include<math.h>


const unsigned char tx_test_data[10] = {0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x6d};  // bɑM̓ẽeXgMA10ڂ̃f[^͑O9f[^̃`FbNTa



#define SI4432_PWRSTATE_READY		01		// ReadyXe[^X
#define SI4432_PWRSTATE_TX		0x09		// MXe[^X
#define SI4432_PWRSTATE_RX		05		// MXe[^X
#define SI4432_PACKET_SENT_INTERRUPT	04		// W[M̊荞
#define SI4432_Rx_packet_received_interrupt   0x02      // M̊荞

#define  TX1_RX0	spi_rw(0x0e|0x80, 0x01)		// M̃AeiXBb`
#define  TX0_RX1	spi_rw(0x0e|0x80, 0x02)		// M̃AeiXBb`
#define  TX0_RX0	spi_rw(0x0e|0x80, 0x00)         // MAMł͂Ȃ̏ꍇ̃AeiXBb`



#define  nIRQ           	RC0		// MCU 
#define  SDO	         	RC1		// MCU 
#define  nSEL			RC2		// MCU o
#define  SDI           		RC3		// MCU o
#define  SCK			RC4		// MCU o
#define  SDN			RC5		// MCU o

#define nIRQ_set		TRISC0		// IO̓́Ao̓WX^ݒ
#define SDO_set			TRISC1		// IO̓́Ao̓WX^ݒ
#define nSEL_set		TRISC2		// IO̓́Ao̓WX^ݒ
#define SDI_set			TRISC3		// IO̓́Ao̓WX^ݒ
#define SCK_set			TRISC4		// IO̓́Ao̓WX^ݒ	
#define SDN_set			TRISC5		// IO̓́Ao̓WX^ݒ


#define INPUT			1
#define OUTPUT			0

unsigned char count_50hz;

unsigned char ItStatus1, ItStatus2;
unsigned char rf_timeout;

unsigned char rx_buf[15];


typedef struct 
{
	
	unsigned char reach_1s				: 1;
	unsigned char rf_reach_timeout			: 1;
	unsigned char is_tx				: 1;
	
	
}	FlagType;

FlagType	                Flag;



void rx_data(void);

void tx_data(void);

unsigned char spi_byte(unsigned char data);
unsigned char spi_rw(unsigned char addr, unsigned char data);

void SI4432_init(void);

void delay_1ms(unsigned char time);

void port_init(void); 

void timer_init(void);

void main()
{ 
	

	unsigned char  i, j, chksum;

	OSCCON = 0X70;	// Ug܂A8M crystal
	
	WDTCON = 0X00;  // WatchDogݒ
	
	
	port_init();  	// IO
 
 	
 	SDN = 1;
 	delay_1ms(10);	// RFW[Zbg
 	
 	SDN = 0;
 	delay_1ms(200);	// RFW[͓삷܂ł150msfBC
 
 	
 	SI4432_init();  // RFW[
 	
 	TX0_RX0;	// AeiXBb`Mł͂ȂAMXe[
 
	
	timer_init();
	
	count_50hz = 0;
	Flag.reach_1s = 0;

	INTCON = 0xc0;   // enable interrupt
	
	
	while(1)
	{		
		if(Flag.reach_1s)
		{
			Flag.reach_1s = 0;
			tx_data();		// 鎞ԂԊuɂAf[^𑗐MA AcknowledgeM
		}
		if(!Flag.is_tx)
		{
			if(!nIRQ)
			{ 	
				ItStatus1 = spi_rw(0x03,0x00);	// 荞݂NA								//read the Interrupt Status1 register
				ItStatus2 = spi_rw(0x04,0x00);	// 荞݂NA
				
				SCK = 0;
				nSEL = 0;
				spi_byte(0x7f);		// obt@f[^ǂݍ
				for(i = 0;i<10;i++)	
				{
					rx_buf[i] = spi_byte(0x00);
				}
				nSEL = 1;
				
				spi_rw(0x07|0x80, SI4432_PWRSTATE_READY);	// f[^MAM[hI
									
				chksum = 0;
				for(i=0;i<9;i++)		// ChecksumvZ
        			chksum += rx_buf[i];          	 		
        				
        			
     				if(( chksum == rx_buf[9] )&&( rx_buf[0] == 0x41 ))
     					
     				{
     					
     					;   // f[^M
        			} 
        			else
        			{
        				rx_data();     // Mf[^ȂꍇApMKv
        			}	
        		 
        		}	
		}	
	}	
}


void delay_1ms(unsigned char time)
{
	unsigned char i,k;
	for(k = 0; k< time; k++)
	{
		for(i = 0; i<130; i++)
		{
			NOP();
		}
	}		
}	


void timer_init(void)
{
	T1CON = 0x31; 

	TMR1IE = 1;
	TMR1L = 0x78;	 //^C}[荞݂
	TMR1H = 0xec;
	
}

void interrupt ISR_timer(void)
{
 
 	unsigned char i;
	if(TMR1IF)
   	{
  
   		TMR1L = 0x78;		// 20ms̃^C}[
   		TMR1H = 0xec;
	
		rf_timeout++;
		if(rf_timeout == 25)
		{
			Flag.rf_reach_timeout = 1;	// 0.5MA3bMTimeout^C}[AMAMɂRamp
		}	
		count_50hz++;
    		if(count_50hz==50)  // 
     		{
       			count_50hz=0;
       			Flag.reach_1s = 1;	//1b̃^C}[
       			
     		}		
     		
    		TMR1IF=0;
	}
	
}  

void port_init(void) 
{ 
 	ANSEL = 0;
 	ANSELH = 0;	// lbtADgȂ
 	WPUA = 0;	// vAbvRȂ
 	IOCA = 0;  // IO荞݂Ȃ

 
	nIRQ_set  = INPUT;
	SDO_set   = INPUT;
	nSEL_set  = OUTPUT;
	SDI_set	  = OUTPUT;
	SCK_set	  = OUTPUT;
	SDN_set	  = OUTPUT;
	TRISB5 = OUTPUT;
}	

	



void SI4432_init(void)
{
	
	ItStatus1 = spi_rw(0x03,0x00);		// RFW[荞݂NA
	ItStatus2 = spi_rw(0x04,0x00);
	
	spi_rw(0x06|0x80, 0x00);  //  sv̊荞݂𖳌ɂ
	
	spi_rw(0x07|0x80, SI4432_PWRSTATE_READY);   //  Ready[hɓ
	 


	spi_rw(0x09|0x80, 0x7f);  //  ׃RfT= 12P

	spi_rw(0x0a|0x80, 0x05);	// go͂𖳌ɂ
	spi_rw(0x0b|0x80, 0xea); // GPIO 0 ʂ̏o̓|[gƂĎg
	spi_rw(0x0c|0x80, 0xea); //GPIO 1 ʂ̏o̓|[gƂĎg
	
	spi_rw(0x0d|0x80, 0xf4);  // /GPIO 2 Mf[^o
	
	
	
	spi_rw(0x70|0x80, 0x2c);  
	spi_rw(0x1d|0x80, 0x40);  // afcL
		
	// 1.2K bps setting
	spi_rw(0x1c|0x80, 0x16);	// L̐ݒSilabsExcelɂs܂B
	
	
	spi_rw(0x20|0x80, 0x83);   
	 
	spi_rw(0x21|0x80, 0xc0); //
	spi_rw(0x22|0x80, 0x13);// 
	spi_rw(0x23|0x80, 0xa9); //
	spi_rw(0x24|0x80, 0x00); //
	spi_rw(0x25|0x80, 0x04); //
	
	spi_rw(0x2a|0x80, 0x14);
	spi_rw(0x6e|0x80, 0x09);
	spi_rw(0x6f|0x80, 0xd5);
	
	//1.2K bps setting end		
	
	
		spi_rw(0x30|0x80, 0x8c);   // PH+ FIFO[hLɂAʂ擪ACRC`FbNLɂ
	 
					
		spi_rw(0x32|0x80, 0xff);  // byte0, 1,2,3 wbhR[h
	 
		spi_rw(0x33|0x80, 0x42);//  byte 0,1,2,3 wbhR[hAF3,2
	

		
	spi_rw(0x34|0x80, 16);  // 16NibblePreamble𑗐M
	spi_rw(0x35|0x80, 0x20);  // 4nibblePreamble`FbNKv
	spi_rw(0x36|0x80, 0x2d);  // ByteF0x2dd4
	spi_rw(0x37|0x80, 0xd4);
	spi_rw(0x38|0x80, 0x00);
	spi_rw(0x39|0x80, 0x00);
	spi_rw(0x3a|0x80, 's');  // `FbNKṽwbhR[hFhswwx"
	spi_rw(0x3b|0x80, 'w');
	spi_rw(0x3c|0x80, 'w');
	spi_rw(0x3d|0x80, 'x');
	spi_rw(0x3e|0x80, 10);  // 10Bytẽf[^𑗐M
	spi_rw(0x3f|0x80, 's'); // `FbNKṽwbhR[hFhswwx"
	spi_rw(0x40|0x80, 'w');
	spi_rw(0x41|0x80, 'w');
	spi_rw(0x42|0x80, 'x');
	spi_rw(0x43|0x80, 0xff);  // R[h1,2,3,4̑Sbit`FbNKv
	spi_rw(0x44|0x80, 0xff);  // 
	spi_rw(0x45|0x80, 0xff);  // 
	spi_rw(0x46|0x80, 0xff);  // 
	spi_rw(0x6d|0x80, 0x07);  // őd͕˂ɐݒ

	spi_rw(0x79|0x80, 0x0);  // gzbsOȂ
	spi_rw(0x7a|0x80, 0x0);  // gzbsOȂ
	
	
	spi_rw(0x71|0x80, 0x22); // MɂCLKCFiFo C FSK[hsv
			
	spi_rw(0x72|0x80, 0x30);  // g΍30KHzɐݒ
	

	spi_rw(0x73|0x80, 0x0);  // g΍Ȃ
	spi_rw(0x74|0x80, 0x0);  // g΍Ȃ
	
	
		
	spi_rw(0x75|0x80, 0x53);  // g434ɐݒ
	spi_rw(0x76|0x80, 0x64);  // 
	spi_rw(0x77|0x80, 0x00);
			
		
}




  
void rx_data(void)
{	
	unsigned char i, chksum;
	Flag.is_tx = 0;
	
	spi_rw(0x07|0x80, SI4432_PWRSTATE_READY);	//rfW[Ready[hɓ
	delay_1ms(5);		//

	TX0_RX1;		// AeiXBb`̕ݒ
	
	spi_rw(0x08|0x80, 0x03);  //MAMobt@NA
	spi_rw(0x08|0x80, 0x00);  //MAMobt@NA
		
	spi_rw(0x07|0x80,SI4432_PWRSTATE_RX );  // RFW[M[hɓ
	
	spi_rw(0x05|0x80, SI4432_Rx_packet_received_interrupt);  // RFW[SpbP[Wf[^MA荞݂N
		
	ItStatus1 = spi_rw(0x03,0x00);		//̊荞݃tONA
	ItStatus2 = spi_rw(0x04,0x00);		//̊荞݃tONA
		
}	

void tx_data(void)
{
	unsigned char i;
	
	Flag.is_tx = 1;

	spi_rw(0x07|0x80, SI4432_PWRSTATE_READY);	// rfW[Ready[hɓ

	TX1_RX0;		//AeiXBb`̕ݒ
	
	delay_1ms(5);		// 5msfBC
	
	

	spi_rw(0x08|0x80, 0x03);  // 
	spi_rw(0x08|0x80, 0x00);  // MAMobt@NA
	
	

		
	spi_rw(0x34|0x80, 40);  // 40NibblẽR[h𑗐M
	spi_rw(0x3e|0x80, 10);  // 10Bytẽf[^𑗐M
  	for (i = 0; i<10; i++)
	{
		spi_rw(0x7f|0x80, tx_test_data[i]); 	// MΏۂ̃f[^obt@Ƀ[h
	}
	spi_rw(0x05|0x80, SI4432_PACKET_SENT_INTERRUPT);	// pbP[Wf[^𑗐MA荞݂N
	ItStatus1 = spi_rw(0x03,0x00);		// RFW[̊荞݂NA
	ItStatus2 = spi_rw(0x04,0x00);
	spi_rw(0x07|0x80, SI4432_PWRSTATE_TX);  // M[hɓ
	
	rf_timeout = 0;
	Flag.rf_reach_timeout = 0;
	while(nIRQ)		// 荞݂҂
	{
		
		if(Flag.rf_reach_timeout)
		{
			
			SDN  = 1;		//0.5bŊ荞݂ȂƁARFW[ُɂȂ邱Ƃ𖾂炩ɂ܂AZbgăW[̏s
			delay_1ms(10);
			SDN = 0;
			delay_1ms(200);
			
			SI4432_init();
			break;		// I
		}
			
	}	
  	rx_data();		//rf MAM[hɓ
}	


unsigned char spi_byte(unsigned char data)
{
	unsigned char i;
	
	for (i = 0; i < 8; i++)		// SCKASDIRg[A1BytẽR}h𑗐M鎞A1Bytẽf[^ǂݍ
	{				// nSEL̐܂܂܂B
		if (data & 0x80)
			SDI = 1;
		else
			SDI = 0;
			
		data <<= 1;
		SCK = 1;
		
		if (SDO)
			data |= 0x01;
		else
			data &= 0xfe;
			
		SCK = 0;
	}
	
	return (data);
}
//-------------------------------------------
unsigned char spi_rw(unsigned char addr, unsigned char data)
{
	unsigned char i;
	
	SCK = 0;
	nSEL = 0;
	
	for (i = 0; i < 8; i++) 
	{
		if (addr & 0x80)
			SDI = 1;
		else
			SDI = 0;
		addr <<= 1;
		SCK = 1;
		asm("NOP");
		SCK = 0;
	}
	
	for (i = 0; i < 8; i++) 
	{
		if (data & 0x80)
			SDI = 1;
		else
			SDI = 0;
		data <<= 1;
		SCK = 1;
		if (SDO)
			data |= 0x01;
		else
			data &= 0xfe;
		SCK = 0;
	}
	nSEL = 1;
	SCK = 1;
	return (data);
}


// song end 

  

