#include <reg24le1.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <intrins.h> 
#include "hal_clk.h"
#include "hal_delay.h"	   
#include "memdefs.h"
#include "nordic_common.h"
#include "si4432_io.h"
#include "ezradiopro.h"
#define   INTERRUPT_RFIRQ      	   9
#define   INTERRUPT_TICK 	       13 
#define   INTERRUPT_T0             1  
//#define  TX1_RX0	phyWrite(0x0e, 0x01)		// ״̬߿ض
//#define  TX0_RX1	phyWrite(0x0e, 0x02)		// ״̬߿ض
//#define  TX0_RX0	phyWrite(0x0e, 0x00)         // Ƿ䣬״̬߿ض
sbit LED=P0^2;
sbit LED1=P0^3;
unsigned char xdata TxBuffer[64];
unsigned char xdata RxBuffer[64];
extern unsigned char xdata RxIntBuffer[64];
bit flag_200ms=0;
//----------------------------------------------------
//-------------------------------------------------------------
																
void clk_init(void)
{
    hal_clk_set_16m_source(HAL_CLK_XOSC16M);            // Always run on 16MHz crystal oscillator
    hal_clklf_set_source(HAL_CLKLF_XOSC16M_SYNTH);      // Synthesize 32 KHz from 16 MHz clock  
    hal_clk_regret_xosc16m_on(true);                    // Keep XOSC16M on in register retention
}
void IO_init(void)
{
  P0=0;
  P1=0;
  P0DIR=0X00;
  P1DIR=0X00;
  P0DIR |=0XE0; 
  P1DIR |=0XDF; 

  P0CON = 0x60;	 //SEL	  0
  P0CON = 0x61;	 //SCLK	   0
  P0CON = 0x62;	 //LED		0
  P0CON = 0x63;  //LED   	 0
  P0CON = 0x64;	 //SDI		  0
  P0CON = 0x55;	 //SDO		   1	  һ
  P0CON = 0x76;    		
  P0CON = 0x77;    		
  
  P1CON = 0x70;    				
  P1CON = 0x71;    			
  P1CON = 0x72;	   			
  P1CON = 0x73;			
  P1CON = 0x74;					
  P1CON = 0x65;	//SDN				  
  P1CON = 0x56; //IRQ   
}
void init_si4432_io(void)
{
  	si4432_SEL=1;    
	si4432_SCLK=0;
    SDN = 0;
	delay_ms(100);
}
void timer0_init()
{
   TMOD=0x01;
   TH0=0xcb;  //10msжһ
   TL0=0xea;
   ET0=1;
   TR0=0;
   EA=1;
}
void TIMER0_IRQ(void) interrupt INTERRUPT_T0
{
   TH0=0xcb;                               //10msжһ
   TL0=0xea;
}	
void rtc2_init(void)
{
	CLKLFCTRL=0x01;									   	// ʹRC 32KHzʱ
	RTC2CMP0=0x98;										// ʱ1sec
	RTC2CMP1=0x19;
	RTC2CON=0x06;										// Ƚģʽ
	WUIRQ=1;											// TICKж
}
/**************************************************
ܣRTC2
**************************************************/
void rtc2_on(void)
{
	RTC2CON |=0x01;		//ʱ							
}
/**************************************************
ܣرRTC2
**************************************************/

void rtc2_off(void)
{													  	
	RTC2CON &=~0x01;							   		
}
void RTC2_IRQ(void) interrupt INTERRUPT_TICK 
{
  flag_200ms=1;
} 
void check_rx(void)
{
   unsigned char status;
   if(si4432_IRQ==0)    //յж֮Ӧλ
   {
      status = phyRead(EZRADIOPRO_INTERRUPT_STATUS_2);
      status = phyRead(EZRADIOPRO_INTERRUPT_STATUS_1);

      if((status & EZRADIOPRO_IPKVALID)==EZRADIOPRO_IPKVALID)
      {
         if(RxPacketReceived==0)
         {
            RxPacketLength = phyRead(EZRADIOPRO_RECEIVED_PACKET_LENGTH);
            RxIntphyReadFIFO(RxPacketLength, RxIntBuffer);
            RxPacketReceived = 1;
         }
         else					      //ɾʹⲿжʱӦж ⲿжϻûֽ꣬뵽ж
         {
           // Clear RX FIFO
            status = phyRead(EZRADIOPRO_OPERATING_AND_FUNCTION_CONTROL_2);
            status |= EZRADIOPRO_FFCLRRX;
            phyWrite(EZRADIOPRO_OPERATING_AND_FUNCTION_CONTROL_2, status);
            status &= ~EZRADIOPRO_FFCLRRX;
            phyWrite(EZRADIOPRO_OPERATING_AND_FUNCTION_CONTROL_2, status);
         }
      }
      else if((status & EZRADIOPRO_ICRCERROR)==EZRADIOPRO_ICRCERROR)
      {
         RxErrors++;
      }
      else
      {

      }
     // enable packet valid and CRC error IRQ
     phyWrite(EZRADIOPRO_INTERRUPT_ENABLE_1, EZRADIOPRO_ENPKVALID|EZRADIOPRO_ENCRCERROR);
     phyWrite(EZRADIOPRO_INTERRUPT_ENABLE_2, 0x00);

     // enable RX again
     phyWrite(EZRADIOPRO_OPERATING_AND_FUNCTION_CONTROL_1,(EZRADIOPRO_RXON|EZRADIOPRO_XTON));
   }
}
void main()
{
 //  unsigned char volatile status_rssi;
   unsigned char i;
   unsigned char volatile status;
   clk_init();
   while(hal_clk_get_16m_source()!= HAL_CLK_XOSC16M);
   IO_init();
   RFCKEN = 0;                                 		    // RFʱ
   RF     = 0;											//RFж
   rtc2_init();
   init_si4432_io();
   status = ppPhyInit();
   status = ppPhyInitRadio();
//   TX0_RX0;	// ߿زڷ䣬״̬
   EA=1;
   rtc2_off();
   for (i=0;i<8;i++)
   {
      TxBuffer[i] = i;
   }
   status = ppPhyRxOn();
   while(1)								  
   {
       check_rx();	
   	   if(RxPacketReceived)
       {
         status=ppPhyGetRxPacket(RxPacketLength, RxBuffer);
		 if(status==SI4432_STATUS_SUCCESS)
		 {
		   if((RxBuffer[0]==0)&&(RxBuffer[7]==7))
		   {
		       status = ppPhyTx(8,TxBuffer);
               if(status==SI4432_STATUS_SUCCESS)
			   {
			      LED1=~LED1;
		          LED=~LED;
			   }
			   status = ppPhyRxOn();
		   }
		 }
      }
   } 
}

